/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty;

import java.math.BigInteger;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import ru.ussgroup.security.trusty.TrustyCertValidationCode;
import ru.ussgroup.security.trusty.TrustyCertificateValidator;
import ru.ussgroup.security.trusty.TrustyKeyUsage;
import ru.ussgroup.security.trusty.TrustyKeyUsageChecker;
import ru.ussgroup.security.trusty.exception.TrustyOCSPCertificateException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNonceException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNotAvailableException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPUnknownProblemException;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPStatus;
import ru.ussgroup.security.trusty.utils.ExceptionHandler;
import ru.ussgroup.security.trusty.utils.SignedData;
import ru.ussgroup.security.trusty.utils.VerifiedData;

public class TrustySignatureVerifier {
    private TrustyCertificateValidator certificateValidator;

    public TrustySignatureVerifier(TrustyCertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public List<VerifiedData> verify(List<SignedData> list) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return this.verify(list, new Date());
    }

    public List<VerifiedData> verify(List<SignedData> list, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return ExceptionHandler.handleFutureResult(this.verifyAsync(list, date));
    }

    public CompletableFuture<List<VerifiedData>> verifyAsync(List<SignedData> list) {
        return this.verifyAsync(list, new Date());
    }

    public CompletableFuture<List<VerifiedData>> verifyAsync(List<SignedData> list, Date date) {
        Set<X509Certificate> certs = list.stream().map(SignedData::getCert).collect(Collectors.toSet());
        CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> certResultsFuture = this.certificateValidator.validateAsync(certs, date);
        CompletableFuture<List> dataResultsFuture = CompletableFuture.supplyAsync(() -> list.parallelStream().map(sd -> {
            VerifiedData vd = new VerifiedData((SignedData)sd);
            try {
                Signature s = Signature.getInstance(sd.getCert().getPublicKey().getAlgorithm(), "KALKAN");
                s.initVerify(sd.getCert().getPublicKey());
                s.update(sd.getData());
                if (!TrustyKeyUsageChecker.getKeyUsage(sd.getCert()).contains((Object)TrustyKeyUsage.SIGNING)) {
                    vd.setCertStatus(TrustyCertValidationCode.NOT_FOR_SIGNING);
                    throw new CertificateException();
                }
                if (!s.verify(sd.getSignature())) {
                    Signature s2 = Signature.getInstance(sd.getCert().getPublicKey().getAlgorithm(), "KALKAN");
                    s2.initVerify(sd.getCert().getPublicKey());
                    s2.update(sd.getData());
                    if (!s2.verify(TrustySignatureVerifier.inverseCopyByte(sd.getSignature(), 0, sd.getSignature().length))) {
                        throw new SignatureException();
                    }
                }
            }
            catch (Exception e) {
                vd.setValid(false);
            }
            return vd;
        }).collect(Collectors.toList()));
        return dataResultsFuture.thenCombine(certResultsFuture, (dataResult, certResult) -> {
            for (VerifiedData vd : dataResult) {
                TrustyCertValidationCode code = (TrustyCertValidationCode)((Object)((Object)certResult.get(vd.getSignedData().getCert().getSerialNumber())));
                if (code == TrustyCertValidationCode.SUCCESS) continue;
                TrustyOCSPStatus status = this.certificateValidator.getStatus(vd.getSignedData().getCert());
                if (code == TrustyCertValidationCode.OCSP_FAILED && status != null && status.getRevocationTime().getTime() > vd.getSignedData().getDate().getTime()) {
                    vd.setValid(vd.isValid());
                    vd.setCertStatus(TrustyCertValidationCode.SUCCESS);
                    continue;
                }
                vd.setValid(false);
                vd.setCertStatus(code);
            }
            return dataResult;
        });
    }

    private static byte[] inverseCopyByte(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
        byte[] arrayOfByte = new byte[paramInt2];
        for (int i = 0; i < paramInt2; ++i) {
            arrayOfByte[paramInt2 - i - 1] = paramArrayOfByte[paramInt1 + i];
        }
        return arrayOfByte;
    }
}

