/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty;

import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.jce.X509Principal;
import sun.security.x509.AVA;
import sun.security.x509.X500Name;

public class TrustySubjectDNParser {
    private Map<String, String> names = new HashMap<String, String>();

    public TrustySubjectDNParser(Principal principal) {
        if (principal instanceof X500Name) {
            X500Name name = (X500Name)principal;
            for (AVA ava : name.allAvas()) {
                String key = ava.getObjectIdentifier().toString();
                String value = ava.getValueString();
                if (key.equals(X509Principal.SERIALNUMBER.getId())) {
                    this.names.put("SERIALNUMBER", value);
                }
                if (key.equals(X509Principal.OU.getId())) {
                    this.names.put("OU", value);
                }
                if (key.equals(X509Principal.CN.getId())) {
                    this.names.put("CN", value);
                }
                if (!key.equals(X509Principal.EmailAddress.getId())) continue;
                this.names.put("EMAILADDRESS", value);
            }
        } else if (principal instanceof X509Principal) {
            X509Principal p = (X509Principal)principal;
            Enumeration enumeration = ((DERSequence)p.getDERObject()).getObjects();
            while (enumeration.hasMoreElements()) {
                DERSet ds = (DERSet)enumeration.nextElement();
                DERSequence seq = (DERSequence)ds.getObjectAt(0);
                String key = seq.getObjectAt(0).toString();
                String value = seq.getObjectAt(1).toString();
                if (key.equals(X509Principal.SERIALNUMBER.getId())) {
                    this.names.put("SERIALNUMBER", value);
                }
                if (key.equals(X509Principal.OU.getId())) {
                    this.names.put("OU", value);
                }
                if (key.equals(X509Principal.CN.getId())) {
                    this.names.put("CN", value);
                }
                if (!key.equals(X509Principal.EmailAddress.getId())) continue;
                this.names.put("EMAILADDRESS", value);
            }
        } else {
            String[] values = principal.getName().split(",");
            this.names = new HashMap<String, String>();
            for (String value : values) {
                this.names.put(value.split("=")[0].trim(), value.split("=")[1].trim());
            }
        }
    }

    public String getIin() {
        return Optional.ofNullable(this.names.get("SERIALNUMBER")).map(s -> s.substring(3)).orElse(null);
    }

    public String getBin() {
        return Optional.ofNullable(this.names.get("OU")).map(s -> s.substring(3)).orElse(null);
    }

    public String getCommonName() {
        return this.names.get("CN");
    }

    public String getEmail() {
        return this.names.get("EMAILADDRESS");
    }
}

