/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.x500.X500PrivateCredential;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class TrustyUtils {
    public static List<X509Certificate> getCertPath(X509Certificate cert, TrustyRepository repository) {
        X509Certificate x509IntermediateCert;
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(cert);
        X509Certificate current = cert;
        while ((x509IntermediateCert = repository.getIntermediateCert(current)) != null) {
            list.add(x509IntermediateCert);
            current = x509IntermediateCert;
        }
        return list;
    }

    public static List<X509Certificate> getFullCertPath(X509Certificate cert, TrustyRepository repository) {
        List<X509Certificate> list = TrustyUtils.getCertPath(cert, repository);
        list.add(repository.getTrustedCert(list.get(list.size() - 1)));
        return list;
    }

    public static String sign(String data, X500PrivateCredential privateCredential) throws SignatureException {
        return Base64.getEncoder().encodeToString(TrustyUtils.sign(data.getBytes(StandardCharsets.UTF_8), privateCredential));
    }

    public static byte[] sign(byte[] data, X500PrivateCredential privateCredential) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(privateCredential.getCertificate().getSigAlgName(), "KALKAN");
            signature.initSign(privateCredential.getPrivateKey());
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String sign(String data, PrivateKey privateKey) throws SignatureException {
        return Base64.getEncoder().encodeToString(TrustyUtils.sign(data.getBytes(StandardCharsets.UTF_8), privateKey));
    }

    @Deprecated
    public static byte[] sign(byte[] data, PrivateKey privateKey) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(privateKey.getAlgorithm(), "KALKAN");
            signature.initSign(privateKey);
            signature.update(data);
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadCertFromResources(String path) {
        try (InputStream in = TrustyUtils.class.getResourceAsStream(path);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(in);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate loadCertFromFile(String path) {
        try (FileInputStream in = new FileInputStream(path);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(in);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X500PrivateCredential loadCredentialFromResources(String path, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            try (InputStream in = TrustyUtils.class.getResourceAsStream(path);){
                X500PrivateCredential x500PrivateCredential = TrustyUtils.loadCredentialFromStream(password, keyStore, in);
                return x500PrivateCredential;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X500PrivateCredential loadCredentialFromFile(String path, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance("pkcs12");
            try (FileInputStream in = new FileInputStream(path);){
                X500PrivateCredential x500PrivateCredential = TrustyUtils.loadCredentialFromStream(password, keyStore, in);
                return x500PrivateCredential;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toBase64(X509Certificate certificate) throws CertificateEncodingException {
        return new String(Base64.getEncoder().encode(certificate.getEncoded()));
    }

    public static String toBase64(Key key) {
        return new String(Base64.getEncoder().encode(key.getEncoded()));
    }

    public static X509Certificate loadFromString(String base64Encoded) throws CertificateParsingException {
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(TrustyUtils.removeNewLines(base64Encoded))));
        }
        catch (Exception e) {
            throw new CertificateParsingException(e);
        }
        if (cert == null) {
            throw new CertificateParsingException();
        }
        return cert;
    }

    private static X500PrivateCredential loadCredentialFromStream(String password, KeyStore keyStore, InputStream in) {
        try {
            keyStore.load(in, password.toCharArray());
            Enumeration<String> aliases = keyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                return new X500PrivateCredential((X509Certificate)keyStore.getCertificate(alias), (PrivateKey)keyStore.getKey(alias, password.toCharArray()));
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeNewLines(String s) {
        return s.replace("\r", "").replace("\n", "").replace(" ", "");
    }

    static {
        if (Security.getProvider("KALKAN") == null) {
            Security.addProvider((Provider)new KalkanProvider());
        }
    }
}

