/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.ocsp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPStatus;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidationResult;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidator;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class TrustyCachedOCSPValidator
implements TrustyOCSPValidator {
    private final Cache<BigInteger, TrustyOCSPStatus> certificateStatusCache;
    private final Cache<BigInteger, TrustyOCSPStatus> trustedCertificateStatusCache;
    private final TrustyOCSPValidator validator;
    private final TrustyRepository repository;

    public TrustyCachedOCSPValidator(TrustyOCSPValidator validator, TrustyRepository repository, int cachedTime, int trustedCachedTime) {
        this.validator = validator;
        this.repository = repository;
        this.certificateStatusCache = CacheBuilder.newBuilder().maximumSize(50000L).expireAfterWrite((long)cachedTime, TimeUnit.MINUTES).build();
        this.trustedCertificateStatusCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite((long)trustedCachedTime, TimeUnit.MINUTES).build();
    }

    @Override
    public CompletableFuture<TrustyOCSPValidationResult> validateAsync(Set<X509Certificate> certs) {
        HashMap<BigInteger, TrustyOCSPStatus> cachedStatuses = new HashMap<BigInteger, TrustyOCSPStatus>();
        HashSet<X509Certificate> toProcess = new HashSet<X509Certificate>(certs);
        Iterator it = toProcess.iterator();
        while (it.hasNext()) {
            X509Certificate checkedCert = (X509Certificate)it.next();
            TrustyOCSPStatus status = (TrustyOCSPStatus)this.trustedCertificateStatusCache.getIfPresent((Object)checkedCert.getSerialNumber());
            if (status == null) {
                status = (TrustyOCSPStatus)this.certificateStatusCache.getIfPresent((Object)checkedCert.getSerialNumber());
            }
            if (status == null) continue;
            cachedStatuses.put(checkedCert.getSerialNumber(), status);
            it.remove();
        }
        if (!toProcess.isEmpty()) {
            return this.validator.validateAsync(toProcess).thenApply(validationResult -> {
                ArrayList<X509Certificate> trustedAndIntermediateCerts = new ArrayList<X509Certificate>(this.repository.getTrustedCerts());
                trustedAndIntermediateCerts.addAll(this.repository.getIntermediateCerts());
                Map<BigInteger, TrustyOCSPStatus> freshStatuses = validationResult.getStatuses();
                for (X509Certificate checkedCert : toProcess) {
                    TrustyOCSPStatus status = freshStatuses.get(checkedCert.getSerialNumber());
                    Cache<BigInteger, TrustyOCSPStatus> cache = this.certificateStatusCache;
                    for (X509Certificate trustedCert : trustedAndIntermediateCerts) {
                        if (!trustedCert.getSerialNumber().equals(checkedCert.getSerialNumber())) continue;
                        cache = this.trustedCertificateStatusCache;
                        break;
                    }
                    cache.put((Object)checkedCert.getSerialNumber(), (Object)status);
                }
                freshStatuses.putAll(cachedStatuses);
                return new TrustyOCSPValidationResult(validationResult.getResponse(), freshStatuses);
            });
        }
        CompletableFuture<TrustyOCSPValidationResult> completableFuture = new CompletableFuture<TrustyOCSPValidationResult>();
        completableFuture.complete(new TrustyOCSPValidationResult(null, cachedStatuses));
        return completableFuture;
    }
}

