/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.ocsp.kalkan;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.ocsp.CertificateID;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPReqGenerator;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNotAvailableException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPUnknownProblemException;
import ru.ussgroup.security.trusty.ocsp.kalkan.KalkanOCSPResponse;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class KalkanOCSPRequestSender {
    private final String ocspUrl;
    private final TrustyRepository trustyRepository;
    private static final AsyncHttpClient httpClient;
    private final SecureRandom sr = new SecureRandom();
    private Inet4Address addr;

    public KalkanOCSPRequestSender(String ocspUrl, String ip, TrustyRepository trustyRepository) throws UnknownHostException {
        this.ocspUrl = ocspUrl;
        this.trustyRepository = trustyRepository;
        this.addr = (Inet4Address)InetAddress.getByName(ip);
    }

    public KalkanOCSPResponse sendRequest(Set<X509Certificate> certs) {
        byte[] nonce = new byte[8];
        this.sr.nextBytes(nonce);
        try {
            ArrayList<CertificateID> ids = new ArrayList<CertificateID>();
            for (X509Certificate cert : certs) {
                X509Certificate issuer = this.trustyRepository.getIssuer(cert);
                if (issuer == null) {
                    throw new TrustyOCSPUnknownProblemException("Certificate issuer not found");
                }
                try {
                    ids.add(new CertificateID(CertificateID.HASH_SHA1, issuer, cert.getSerialNumber(), "KALKAN"));
                }
                catch (OCSPException e) {
                    throw new TrustyOCSPUnknownProblemException(e);
                }
            }
            ListenableFuture f = ((AsyncHttpClient.BoundRequestBuilder)httpClient.preparePost(this.ocspUrl).setHeader("Content-Type", "application/ocsp-request").setInetAddress((InetAddress)this.addr)).setBody(this.getOcspPackage(ids, nonce)).execute((AsyncHandler)new AsyncCompletionHandler<OCSPResp>(){

                public OCSPResp onCompleted(Response response) throws Exception {
                    return new OCSPResp(response.getResponseBodyAsBytes());
                }
            });
            CompletableFuture<OCSPResp> completableFuture = new CompletableFuture<OCSPResp>();
            f.addListener(() -> {
                try {
                    completableFuture.complete((OCSPResp)f.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    completableFuture.completeExceptionally(new RuntimeException(new TrustyOCSPNotAvailableException(e)));
                }
            }, r -> r.run());
            return new KalkanOCSPResponse(nonce, completableFuture);
        }
        catch (TrustyOCSPUnknownProblemException e) {
            CompletableFuture<OCSPResp> completableFuture = new CompletableFuture<OCSPResp>();
            completableFuture.completeExceptionally(new RuntimeException(e));
            return new KalkanOCSPResponse(nonce, completableFuture);
        }
    }

    private byte[] getOcspPackage(List<CertificateID> ids, byte[] nonce) throws TrustyOCSPUnknownProblemException {
        try {
            OCSPReqGenerator gen = new OCSPReqGenerator();
            for (CertificateID id : ids) {
                gen.addRequest(id);
            }
            gen.setRequestExtensions(this.generateExtensions(nonce));
            return gen.generate().getEncoded();
        }
        catch (Exception e) {
            throw new TrustyOCSPUnknownProblemException(e);
        }
    }

    private X509Extensions generateExtensions(byte[] nonce) {
        Hashtable<DERObjectIdentifier, X509Extension> exts = new Hashtable<DERObjectIdentifier, X509Extension>();
        exts.put(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, new X509Extension(false, (ASN1OctetString)new DEROctetString((DEREncodable)new DEROctetString(nonce))));
        return new X509Extensions(exts);
    }

    static {
        if (Security.getProvider("KALKAN") == null) {
            Security.addProvider((Provider)new KalkanProvider());
        }
        AsyncHttpClientConfig cfg = new AsyncHttpClientConfig.Builder().setConnectTimeout(10000).setRequestTimeout(10000).build();
        httpClient = new AsyncHttpClient(cfg);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                httpClient.close();
            }
        });
    }
}

