/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.ocsp.kalkan;

import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.ocsp.BasicOCSPResp;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.SingleResp;
import ru.ussgroup.security.trusty.TrustyUtils;
import ru.ussgroup.security.trusty.certpath.TrustyCachedCertPathValidator;
import ru.ussgroup.security.trusty.certpath.TrustyCertPathValidator;
import ru.ussgroup.security.trusty.certpath.TrustyCertPathValidatorImpl;
import ru.ussgroup.security.trusty.exception.TrustyOCSPCertificateException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNonceException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPUnknownProblemException;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPStatus;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidationResult;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class KalkanOCSPResponseChecker {
    private final TrustyCertPathValidator validator;

    public KalkanOCSPResponseChecker(TrustyRepository trustyRepository) {
        this.validator = new TrustyCachedCertPathValidator(new TrustyCertPathValidatorImpl(trustyRepository));
    }

    public TrustyOCSPValidationResult checkResponse(OCSPResp response, byte[] nonce) throws TrustyOCSPCertificateException, TrustyOCSPNonceException, TrustyOCSPUnknownProblemException {
        try {
            X509Certificate ocspcert;
            BasicOCSPResp brep;
            block44: {
                if (response.getStatus() != 0) {
                    throw new RuntimeException("Unsuccessful request. Status: " + response.getStatus());
                }
                try {
                    brep = (BasicOCSPResp)response.getResponseObject();
                }
                catch (OCSPException e) {
                    throw new RuntimeException("Unsuccessful request.", e);
                }
                byte[] respNonceExt = brep.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
                if (respNonceExt != null) {
                    try (ASN1InputStream asn1In1 = new ASN1InputStream(respNonceExt);){
                        DERObject derObj = asn1In1.readObject();
                        byte[] extV = ASN1OctetString.getInstance((Object)derObj).getOctets();
                        try (ASN1InputStream asn1In2 = new ASN1InputStream(extV);){
                            derObj = asn1In2.readObject();
                            byte[] receivedNonce = ASN1OctetString.getInstance((Object)derObj).getOctets();
                            if (!Arrays.equals(nonce, receivedNonce)) {
                                throw new TrustyOCSPNonceException("Expected nonce: " + Base64.getEncoder().encode(nonce) + ", but received: " + Base64.getEncoder().encode(receivedNonce));
                            }
                            break block44;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new TrustyOCSPNonceException("Nonce extension not found in response!");
            }
            try {
                ocspcert = brep.getCerts("KALKAN")[0];
            }
            catch (NoSuchProviderException | OCSPException e) {
                throw new RuntimeException(e);
            }
            try {
                String base64 = TrustyUtils.toBase64(ocspcert);
                ocspcert = TrustyUtils.loadFromString(base64);
                this.validator.validate(ocspcert);
            }
            catch (Exception e1) {
                throw new TrustyOCSPCertificateException(e1);
            }
            try {
                if (!brep.verify(ocspcert.getPublicKey(), "KALKAN")) {
                    throw new RuntimeException("Unable to verify response");
                }
            }
            catch (NoSuchProviderException | OCSPException e) {
                throw new RuntimeException(e);
            }
            HashMap<BigInteger, TrustyOCSPStatus> statuses = new HashMap<BigInteger, TrustyOCSPStatus>();
            for (SingleResp singleResp : brep.getResponses()) {
                Object status = singleResp.getCertStatus();
                if (status == null) {
                    statuses.put(singleResp.getCertID().getSerialNumber(), new TrustyOCSPStatus(1));
                    continue;
                }
                if (status instanceof RevokedStatus) {
                    int reason = 0;
                    if (((RevokedStatus)status).hasRevocationReason()) {
                        reason = ((RevokedStatus)status).getRevocationReason();
                    }
                    statuses.put(singleResp.getCertID().getSerialNumber(), new TrustyOCSPStatus(2, ((RevokedStatus)status).getRevocationTime(), reason));
                    continue;
                }
                statuses.put(singleResp.getCertID().getSerialNumber(), new TrustyOCSPStatus(3));
            }
            return new TrustyOCSPValidationResult(response, statuses);
        }
        catch (RuntimeException e) {
            throw new TrustyOCSPUnknownProblemException(e);
        }
    }

    static {
        if (Security.getProvider("KALKAN") == null) {
            Security.addProvider((Provider)new KalkanProvider());
        }
    }
}

