/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.repository;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class TrustyKeyStoreRepository
implements TrustyRepository {
    public static final String KEYSTORE_PROD_PATH = "/ca/kalkan_repository.jks";
    public static final String KEYSTORE_TEST_PATH = "/ca_test/kalkan_repository.jks";
    private final Map<String, X509Certificate> intermediateMap = new ConcurrentHashMap<String, X509Certificate>();
    private final Map<String, X509Certificate> trustedMap = new ConcurrentHashMap<String, X509Certificate>();

    public TrustyKeyStoreRepository(String resourcePath) {
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            try (InputStream in = TrustyKeyStoreRepository.class.getResourceAsStream(resourcePath);){
                keyStore.load(in, "123456".toCharArray());
            }
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(aliases.nextElement());
                if (Arrays.equals(cert.getSubjectX500Principal().getEncoded(), cert.getIssuerX500Principal().getEncoded())) {
                    this.trustedMap.put(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getSubjectX500Principal().getEncoded()), cert);
                    continue;
                }
                this.intermediateMap.put(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getSubjectX500Principal().getEncoded()), cert);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Collection<X509Certificate> getTrustedCerts() {
        return ImmutableList.copyOf(this.trustedMap.values());
    }

    @Override
    public X509Certificate getIntermediateCert(X509Certificate cert) {
        return this.intermediateMap.get(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getIssuerX500Principal().getEncoded()));
    }

    @Override
    public X509Certificate getTrustedCert(X509Certificate cert) {
        return this.trustedMap.get(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getIssuerX500Principal().getEncoded()));
    }

    @Override
    public X509Certificate getIssuer(X509Certificate cert) {
        X509Certificate issuer = this.intermediateMap.get(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getIssuerX500Principal().getEncoded()));
        if (issuer != null) {
            return issuer;
        }
        return this.trustedMap.get(cert.getSigAlgOID() + Base64.getEncoder().encodeToString(cert.getIssuerX500Principal().getEncoded()));
    }

    @Override
    public Collection<X509Certificate> getIntermediateCerts() {
        return ImmutableList.copyOf(this.intermediateMap.values());
    }

    static {
        if (Security.getProvider("KALKAN") == null) {
            Security.addProvider((Provider)new KalkanProvider());
        }
    }
}

