/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.saaj.SAAJOutInterceptor;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;

public class ClientUtil {
    public static final File WSDL_CACHE_DIR = new File(System.getProperty("java.io.tmpdir"), "wsdl_cache");
    private static ConcurrentMap<String, URL> wsdlCache = new ConcurrentHashMap<String, URL>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL from, File to) throws IOException {
        to.getParentFile().mkdirs();
        HttpURLConnection uc = (HttpURLConnection)from.openConnection();
        uc.setRequestProperty("Connection", "close");
        try (InputStream in = from.openStream();
             FileOutputStream out = new FileOutputStream(to);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            uc.disconnect();
        }
    }

    public static <T> T createService(Class<T> serviceClass, URL wsdl, String serviceName, String login, String password, boolean printSoapMessages, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        QName qname = new QName("esf", serviceName);
        Service service = Service.create((URL)ClientUtil.load(serviceClass, wsdl), (QName)qname);
        Object soapService = service.getPort(serviceClass);
        if (login != null) {
            ClientUtil.addWsSecurityHeaders(soapService, login, password);
        }
        if (printSoapMessages) {
            ClientUtil.addLoginInterceptors(soapService);
        }
        if (interceptors != null) {
            Client client = ClientProxy.getClient((Object)soapService);
            interceptors.forEach(interceptor -> (interceptor instanceof LoggingInInterceptor ? client.getInInterceptors() : client.getOutInterceptors()).add(interceptor));
        }
        ClientUtil.disableCNCheck(soapService);
        ClientUtil.configureHttp(soapService);
        return (T)soapService;
    }

    private static URL load(Class<?> serviceClass, URL wsdl) throws Exception {
        return wsdlCache.computeIfAbsent(serviceClass.getSimpleName(), path -> {
            try {
                File file = new File(WSDL_CACHE_DIR, (String)path);
                ClientUtil.copy(wsdl, file);
                return file.toURI().toURL();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void configureHttp(Object soapService) {
        Client client = ClientProxy.getClient((Object)soapService);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(30000L);
        conduit.setClient(httpClientPolicy);
    }

    private static void disableCNCheck(Object soapService) {
        Client client = ClientProxy.getClient((Object)soapService);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        TLSClientParameters params = new TLSClientParameters();
        TrustManager[] simpleTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        params.setUseHttpsURLConnectionDefaultHostnameVerifier(true);
        params.setDisableCNCheck(true);
        params.setTrustManagers(simpleTrustManager);
        conduit.setTlsClientParameters(params);
    }

    private static void addLoginInterceptors(Object soapService) {
        Client client = ClientProxy.getClient((Object)soapService);
        LoggingInInterceptor loggingInInterceptor = new LoggingInInterceptor();
        loggingInInterceptor.setPrettyLogging(true);
        client.getInInterceptors().add(loggingInInterceptor);
        LoggingOutInterceptor loggingOutInterceptor = new LoggingOutInterceptor();
        loggingOutInterceptor.setPrettyLogging(true);
        client.getOutInterceptors().add(loggingOutInterceptor);
    }

    private static void addWsSecurityHeaders(Object service, String login, String password) {
        Client client = ClientProxy.getClient((Object)service);
        Endpoint endpoint = client.getEndpoint();
        endpoint.getOutInterceptors().add(new SAAJOutInterceptor());
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        outProps.put("action", "UsernameToken");
        outProps.put("user", login);
        outProps.put("passwordType", "PasswordText");
        outProps.put("passwordCallbackRef", callbacks -> {
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
            pc.setPassword(password);
        });
        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor(outProps);
        endpoint.getOutInterceptors().add(wssOut);
    }
}

