/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.client.impl;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import ru.uss.esf.client.ClientUtil;

public class SerilizableJaxwsService<T>
implements Supplier<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceClassName;
    private URL wsdl;
    private String serviceName;
    private String login;
    private String password;
    private boolean printSoapMessages = false;
    private List<AbstractLoggingInterceptor> interceptors;
    private transient T service = null;

    public SerilizableJaxwsService(Class<T> serviceClass, URL wsdl, String serviceName, String login, String password, boolean printSoapMessages) {
        this.serviceClassName = serviceClass.getCanonicalName();
        this.wsdl = wsdl;
        this.serviceName = serviceName;
        this.login = login;
        this.password = password;
        this.printSoapMessages = printSoapMessages;
    }

    public SerilizableJaxwsService(Class<T> serviceClass, URL wsdl, String serviceName, String login, String password, boolean printSoapMessages, List<AbstractLoggingInterceptor> interceptors) {
        this(serviceClass, wsdl, serviceName, login, password, printSoapMessages);
        this.interceptors = interceptors;
    }

    @Override
    public T get() {
        if (this.service == null) {
            Class<?> serviceClass;
            try {
                serviceClass = Class.forName(this.serviceClassName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                this.service = ClientUtil.createService(serviceClass, this.wsdl, this.serviceName, this.login, this.password, this.printSoapMessages, this.interceptors);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.service;
    }
}

