/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.security.SignatureException;
import javax.security.auth.x500.X500PrivateCredential;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.utils.SignatureHelper;
import ru.uss.esf.core.utils.AwpXmlUtils;
import ru.uss.esf.model.awp.abstractawp.AbstractAwp;

public class AwpSignatureHelper
extends SignatureHelper {
    public static String sign(AbstractAwp awp, X500PrivateCredential certificate) throws SignatureException {
        return SignatureHelper.sign(AwpSignatureHelper.extractSignatureData(awp), certificate);
    }

    public static String extractSignatureData(AbstractAwp awp) {
        try {
            return AwpXmlUtils.awpToXml(awp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends AbstractAwp> T cloneAwp(T awp) {
        try {
            String xml = AwpXmlUtils.awpToXml(awp);
            Class awpClass = awp.getVersion().getClazz();
            AbstractAwp awpCopy = (AbstractAwp)JAXBUtils.toObject(xml, awpClass);
            awpCopy.setVersion(awp.getVersion());
            return (T)awpCopy;
        }
        catch (Exception e) {
            throw new RuntimeException("Awp signable copy creation failed", e);
        }
    }

    public static String toXML(Object object) {
        return JAXBUtils.toXml(object, null, true, false);
    }
}

