/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.XmlParseException;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.utils.JsonHelper;
import ru.uss.core.xsd.UssSchemaOutputResolver;
import ru.uss.esf.core.utils.xsd.AwpVersionObjectFactory;
import ru.uss.esf.model.awp.AwpUploadInfo;
import ru.uss.esf.model.awp.AwpVersion;
import ru.uss.esf.model.awp.abstractawp.AbstractAwp;
import ru.uss.esf.model.awp.version.v1.AwpV1;
import ru.uss.esf.model.web.awp.container.AwpContainer;

public class AwpXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(AwpXmlUtils.class);
    private static Schema awpContainerSchema;
    private static Schema awpV1Schema;

    public static synchronized Schema getAwpContainerSchema() {
        if (awpContainerSchema == null) {
            awpContainerSchema = JAXBUtils.scheme(AwpContainer.class, sources -> {
                Collections.rotate(sources, 1);
                return (Source[])sources.stream().toArray(Source[]::new);
            });
        }
        return awpContainerSchema;
    }

    public static synchronized Schema getAwpV1Schema() {
        if (awpV1Schema == null) {
            awpV1Schema = JAXBUtils.scheme(AwpV1.class);
        }
        return awpV1Schema;
    }

    private static Unmarshaller createUnmarshaller(Class<?> clazz, Schema schema) {
        try {
            JAXBContext context = JAXBUtils.context(clazz);
            Unmarshaller unmarshallerAwp = context.createUnmarshaller();
            unmarshallerAwp.setSchema(schema);
            unmarshallerAwp.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            return unmarshallerAwp;
        }
        catch (JAXBException e) {
            throw new XmlParseException("Error, creating Unmarshaller for Awp", (Exception)((Object)e));
        }
    }

    public static void unwrapAwp(AwpUploadInfo awpInfo) {
        try {
            AbstractAwp awp = AwpXmlUtils.xmlToAwp(awpInfo.getAwpBody(), awpInfo.getVersion());
            awpInfo.setAwp(awp);
        }
        catch (Exception e) {
            logger.error("Can`t unwrap awpInfo", (Throwable)e);
        }
    }

    public static void unwrapAwpWithValidation(AwpUploadInfo awpInfo) {
        try {
            AbstractAwp awp = AwpXmlUtils.xmlToAwpWithValidation(awpInfo.getAwpBody(), awpInfo.getVersion());
            awpInfo.setAwp(awp);
        }
        catch (Exception e) {
            logger.error("Can`t unwrap awpInfo", (Throwable)e);
        }
    }

    public static void unwrapAwpList(List<AwpUploadInfo> awpInfoList) {
        for (AwpUploadInfo awpInfo : awpInfoList) {
            AwpXmlUtils.unwrapAwpWithValidation(awpInfo);
        }
    }

    public static AbstractAwp xmlToAwp(String xml, String version) {
        return AwpXmlUtils.xmlToAwp(xml, AwpVersion.valueOf((String)version));
    }

    public static AbstractAwp xmlToAwp(String xml, AwpVersion version) {
        return (AbstractAwp)JAXBUtils.toObject(xml, version.getClazz());
    }

    public static AbstractAwp xmlToAwpWithValidation(String xml, AwpVersion version) {
        return (AbstractAwp)JAXBUtils.toObjectWithSchemeValidation(xml, AwpXmlUtils.createUnmarshaller(version.getClazz(), AwpXmlUtils.getSchemaByVersion(version)));
    }

    public static String awpToXml(AbstractAwp awp) {
        return JAXBUtils.toXml(awp, null, true, true);
    }

    public static UssSchemaOutputResolver createAwpXsdResolver(Class<? extends AbstractAwp> clazz) {
        return JAXBUtils.resolver(clazz, AwpXmlUtils.getAwpObjectFactory(clazz));
    }

    public static Class<?> getAwpObjectFactory(Class<? extends AbstractAwp> clazz) {
        if (clazz.equals(AwpV1.class)) {
            return AwpVersionObjectFactory.class;
        }
        throw new IllegalStateException();
    }

    public static AwpContainer unmarshalAwpContainer(String filePath) throws Exception {
        try {
            String data = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            AwpContainer awpContainer = JAXBUtils.toObject(data, AwpContainer.class);
            return awpContainer;
        }
        finally {
            new File(filePath).delete();
        }
    }

    private static Schema getSchemaByVersion(AwpVersion version) {
        switch (version) {
            case AwpV1: {
                return AwpXmlUtils.getAwpV1Schema();
            }
        }
        throw new UnsupportedOperationException("Unknown AWP version: " + version);
    }

    public static void main(String[] args) {
        AbstractAwp abstractAwp = AwpXmlUtils.xmlToAwpWithValidation("<awp xmlns=\"v1.awp\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><awpType xmlns=\"\">PRIMARY</awpType><date xmlns=\"\">31.05.2023</date><number xmlns=\"\">\u0411\u041a000000043</number><performedDate xmlns=\"\">31.05.2023</performedDate><contract xmlns=\"\" xmlns:d2p1=\"v1.awp\"><isContract>false</isContract></contract><recipients xmlns=\"\" xmlns:d2p1=\"v1.awp\"><recipient><address>\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d, \u0410\u043a\u043c\u043e\u043b\u0438\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c</address><registrationType>ENTERPRISE</registrationType><tin>020640002269</tin><bankDetails><bank>\u0410\u041e \"\u0411\u0430\u043d\u043a \u0426\u0435\u043d\u0442\u0440\u041a\u0440\u0435\u0434\u0438\u0442\"</bank><bik>KCJBKZKX</bik><iik>KZ18385147SD15987456</iik><kbe>17</kbe></bankDetails><name>\u0422\u043e\u0432\u0430\u0440\u0438\u0449\u0435\u0441\u0442\u0432\u043e \u0441 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0439 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c\u044e \"\u0422\u0414 \u041b\u0430\u043a\u043e\u043c\u043a\u0430\"</name><nonResident>false</nonResident></recipient></recipients><senders xmlns=\"\" xmlns:d2p1=\"v1.awp\"><sender><address>\u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d, \u0412\u043e\u0441\u0442\u043e\u0447\u043d\u043e-\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c, \u0413\u043b\u0443\u0431\u043e\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d</address><registrationType>ENTREPRENEUR</registrationType><tin>840121401384</tin><bankDetails/><name>\u0418\u041f \u041d\u0430\u0437\u044b\u043c</name></sender></senders><worksPerformed xmlns=\"\" xmlns:d2p1=\"v1.awp\"><currencyCode>KZT</currencyCode><totalNdsAmount>0</totalNdsAmount><totalSumWithTax>80000</totalSumWithTax><totalSumWithoutTax>80000</totalSumWithoutTax><totalTurnoverSize>80000</totalTurnoverSize><works><work><gsvsCode>91.03.10.01</gsvsCode><measureUnitCode>796</measureUnitCode><name>\u0423\u0441\u043b\u0443\u0433\u0438 \u043f\u043e \u043e\u0445\u0440\u0430\u043d\u0435 \u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043c\u0435\u0441\u0442 \u0438 \u0437\u0434\u0430\u043d\u0438\u0439, \u043f\u0430\u043c\u044f\u0442\u043d\u0438\u043a\u043e\u0432 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b</name><ndsAmount>0</ndsAmount><quantity>1</quantity><sumWithTax>80000</sumWithTax><sumWithoutTax>80000</sumWithoutTax><systemName>\u0423\u0441\u043b\u0443\u0433\u0438 \u043f\u043e \u043e\u0445\u0440\u0430\u043d\u0435 \u0438\u0441\u0442\u043e\u0440\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043c\u0435\u0441\u0442 \u0438 \u0437\u0434\u0430\u043d\u0438\u0439, \u043f\u0430\u043c\u044f\u0442\u043d\u0438\u043a\u043e\u0432 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b</systemName><turnoverSize>80000</turnoverSize><unitPriceWithoutTax>80000</unitPriceWithoutTax></work></works></worksPerformed></awp>", AwpVersion.AwpV1);
        System.out.println(JsonHelper.writeValueAsString(abstractAwp));
    }
}

