/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.security.SignatureException;
import javax.security.auth.x500.X500PrivateCredential;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.utils.SignatureHelper;
import ru.uss.esf.core.utils.InvoiceXmlUtil;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.version.InvoiceVersionMapper;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;

public class InvoiceSignatureHelper
extends SignatureHelper {
    public static String sign(AbstractInvoice invoice, X500PrivateCredential certificate) throws SignatureException {
        return SignatureHelper.sign(InvoiceSignatureHelper.extractSignatureData(invoice), certificate);
    }

    public static String extractSignatureData(AbstractInvoice invoice) {
        try {
            return InvoiceXmlUtil.invoiceToXml(invoice);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InvoiceV2 cloneInvoiceV2(InvoiceV2 invoiceV2) {
        InvoiceV2 copyInvoice = InvoiceSignatureHelper.cloneInvoice(invoiceV2);
        copyInvoice.setSellerProjectCode(invoiceV2.getSellerProjectCode());
        copyInvoice.setCustomerProjectCode(invoiceV2.getCustomerProjectCode());
        return copyInvoice;
    }

    public static <T extends AbstractInvoice> T cloneInvoice(T invoice) {
        try {
            String xml = InvoiceXmlUtil.invoiceToXml(invoice);
            Class invoiceClass = InvoiceVersionMapper.getClassByVersion((String)invoice.getVersion());
            AbstractInvoice invoiceCopy = (AbstractInvoice)JAXBUtils.toObject(xml, invoiceClass);
            invoiceCopy.setVersion(invoice.getVersion());
            return (T)invoiceCopy;
        }
        catch (Exception e) {
            throw new RuntimeException("Invoice signable copy creation failed", e);
        }
    }

    public static String toXML(Object object) {
        return JAXBUtils.toXml(object, null, true, false);
    }
}

