/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.ndsbc.api1.ks;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorAware;
import ru.uss.esf.model.ndsbc.ks.KsError;
import ru.uss.esf.model.ndsbc.ks.KsProcessStatus;
import ru.uss.ndsbc.api1.ks.KsStatementUploadResult;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="KsStatementResponse")
@XmlType(name="KsStatementResponse")
@Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0432\u0435\u0442\u043e\u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u042d\u0421\u0424 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u0411\u0412\u0423")
public class KsStatementResponse
implements ErrorAware {
    @XmlElementWrapper(name="acceptedList")
    @XmlElement(name="statementData", required=false)
    @Documentation(value="\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0435 \u041a\u0421")
    private List<KsStatementUploadResult> acceptedList;
    @XmlElementWrapper(name="declinedList")
    @XmlElement(name="statementData", required=false)
    @Documentation(value="\u041e\u0442\u043a\u043b\u043e\u043d\u0435\u043d\u043d\u044b\u0435 \u041a\u0421")
    private List<KsStatementUploadResult> declinedList;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f")
    protected KsProcessStatus status;
    @XmlElementWrapper(name="errorList")
    @XmlElement(required=false, name="error")
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0448\u0438\u0431\u043e\u043a")
    protected List<KsError> errors;

    public KsStatementResponse() {
    }

    public KsStatementResponse(List<KsStatementUploadResult> acceptedList, List<KsStatementUploadResult> declinedList) {
        this.acceptedList = acceptedList;
        this.declinedList = declinedList;
    }

    public static KsStatementResponse successResponse(List<KsStatementUploadResult> acceptedList, List<KsStatementUploadResult> declinedList) {
        KsStatementResponse response = new KsStatementResponse(acceptedList, declinedList);
        response.setStatus(KsProcessStatus.PROCESSED);
        return response;
    }

    public static KsStatementResponse wrongResponse(List<KsStatementUploadResult> acceptedList, List<KsStatementUploadResult> declinedList) {
        KsStatementResponse response = new KsStatementResponse(acceptedList, declinedList);
        response.setStatus(KsProcessStatus.FAILED);
        return response;
    }

    public static KsStatementResponse wrongResponse(List<Error> errorList) {
        KsStatementResponse response = new KsStatementResponse();
        response.setStatus(KsProcessStatus.FAILED);
        response.setErrors(KsError.of(errorList));
        return response;
    }

    public KsProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(KsProcessStatus status) {
        this.status = status;
    }

    public List<KsError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<KsError> errors) {
        this.errors = errors;
    }

    public List<KsStatementUploadResult> getAcceptedList() {
        return this.acceptedList;
    }

    public void setAcceptedList(List<KsStatementUploadResult> acceptedList) {
        this.acceptedList = acceptedList;
    }

    public List<KsStatementUploadResult> getDeclinedList() {
        return this.declinedList;
    }

    public void setDeclinedList(List<KsStatementUploadResult> declinedList) {
        this.declinedList = declinedList;
    }

    public List<Error> getErrorList() {
        return CollectionUtils.isNotEmpty(this.errors) ? KsError.convertToError(this.errors) : Collections.emptyList();
    }
}

