/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.bind.UnmarshalException;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.InvalidCharactersException;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.validation.common.UTF83ByteCheckValidator;
import ru.uss.core.xsd.UssSchemaOutputResolver;
import ru.uss.esf.core.utils.InvoiceXmlUtil;
import ru.uss.vstore.model.uform.UFormInfo;
import ru.uss.vstore.model.uform.UFormUploadInfo;
import ru.uss.vstore.model.uform.abstractuform.AbstractUForm;
import ru.uss.vstore.model.uform.container.UFormContainer;
import ru.uss.vstore.model.uform.version.UFormVersionMapper;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.utils.xsd.UFormVersionObjectFactory;

public class UFormXmlUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(UFormXmlUtils.class);
    private static Schema uFormContainerSchema = JAXBUtils.scheme(UFormContainer.class);

    public static Schema getUFormContainerSchema() {
        return uFormContainerSchema;
    }

    public static String uFormContainerToXml(UFormContainer uFormContainer) {
        return JAXBUtils.toXml(uFormContainer, uFormContainerSchema, false, true);
    }

    public static String uFormToXml(AbstractUForm uForm) {
        return JAXBUtils.toXml(uForm, uFormContainerSchema, false, true);
    }

    public static <T> T xmlToUForm(String xml, Class<T> requiredClass) {
        return JAXBUtils.toObject(xml, requiredClass);
    }

    public static UssSchemaOutputResolver createUFormXsdResolver(Class<? extends AbstractUForm> clazz) {
        return JAXBUtils.resolver(clazz, UFormXmlUtils.getUFormObjectFactory(clazz));
    }

    public static Class<?> getUFormObjectFactory(Class<? extends AbstractUForm> clazz) {
        if (clazz.equals(UFormV1.class)) {
            return UFormVersionObjectFactory.class;
        }
        throw new IllegalStateException();
    }

    public static void unwrapUForms(List<UFormUploadInfo> uformInfoList) {
        for (UFormUploadInfo uformInfo : uformInfoList) {
            UFormXmlUtils.unwrapUForm(uformInfo);
        }
    }

    public static void unwrapUForm(UFormUploadInfo uformInfo) {
        Class uFormClass = UFormVersionMapper.getClassByVersion((String)uformInfo.getVersion());
        try {
            AbstractUForm uForm = (AbstractUForm)UFormXmlUtils.xmlToUForm(uformInfo.getuFormBody(), uFormClass);
            uformInfo.setuForm(uForm);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof UnmarshalException) {
                LOGGER.error(e.getMessage());
                throw new IllegalStateException(cause);
            }
            LOGGER.error("Can`t unwrap uformInfo", (Throwable)e);
        }
    }

    public static void unwrapUForm(UFormInfo uformInfo) {
        Class uFormClass = UFormVersionMapper.getClassByVersion((String)uformInfo.getVersion());
        try {
            AbstractUForm uForm = (AbstractUForm)UFormXmlUtils.xmlToUForm(uformInfo.getuFormBody(), uFormClass);
            uformInfo.setuForm(uForm);
        }
        catch (Exception e) {
            LOGGER.error("Can`t unwrap uformInfo", (Throwable)e);
        }
    }

    public static AbstractUForm wrapUForm(String uFormVersion, String uFormXml) {
        Class uFormClass = UFormVersionMapper.getClassByVersion((String)uFormVersion);
        return (AbstractUForm)UFormXmlUtils.xmlToUForm(uFormXml, uFormClass);
    }

    public static UFormContainer unmarshalUFormContainer(String filePath) throws IOException, IllegalArgumentException {
        try {
            String data = InvoiceXmlUtil.removeBOM(new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8));
            if (!UTF83ByteCheckValidator.validateString((String)data)) {
                throw new InvalidCharactersException();
            }
            UFormContainer uFormContainer = JAXBUtils.toObject(data, UFormContainer.class);
            return uFormContainer;
        }
        finally {
            new File(filePath).delete();
        }
    }
}

