/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.certpath;

import java.security.SignatureException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.stream.Collectors;
import ru.ussgroup.security.trusty.TrustyUtils;
import ru.ussgroup.security.trusty.certpath.TrustyCertPathValidator;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class TrustyCertPathValidatorImpl
implements TrustyCertPathValidator {
    final TrustyRepository repository;

    public TrustyCertPathValidatorImpl(TrustyRepository repository) {
        this.repository = repository;
    }

    @Override
    public void validate(X509Certificate cert) throws CertificateNotYetValidException, CertificateExpiredException, SignatureException, CertPathValidatorException {
        this.validate(cert, new Date());
    }

    @Override
    public void validate(X509Certificate cert, Date date) throws CertificateNotYetValidException, CertificateExpiredException, SignatureException, CertPathValidatorException {
        try {
            PKIXBuilderParameters params = new PKIXBuilderParameters(this.repository.getTrustedCerts().stream().map(c -> new TrustAnchor((X509Certificate)c, null)).collect(Collectors.toSet()), null);
            params.setRevocationEnabled(false);
            params.setDate(date != null ? date : cert.getNotBefore());
            CertPathValidator.getInstance("PKIX").validate(CertificateFactory.getInstance("X.509").generateCertPath(TrustyUtils.getCertPath(cert, this.repository)), params);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof CertificateNotYetValidException) {
                    CertificateNotYetValidException e1 = (CertificateNotYetValidException)e.getCause();
                    throw e1;
                }
                if (e.getCause() instanceof CertificateExpiredException) {
                    CertificateExpiredException e1 = (CertificateExpiredException)e.getCause();
                    throw e1;
                }
                if (e.getCause() instanceof SignatureException) {
                    SignatureException e1 = (SignatureException)e.getCause();
                    throw e1;
                }
            }
            if (e instanceof CertPathValidatorException) {
                CertPathValidatorException e1 = (CertPathValidatorException)e;
                throw e1;
            }
            throw new CertPathValidatorException(e);
        }
    }
}

