/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.ocsp.kalkan;

import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kz.gov.pki.kalkan.ocsp.OCSPResp;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidationResult;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidator;
import ru.ussgroup.security.trusty.ocsp.kalkan.KalkanOCSPRequestSender;
import ru.ussgroup.security.trusty.ocsp.kalkan.KalkanOCSPResponse;
import ru.ussgroup.security.trusty.ocsp.kalkan.KalkanOCSPResponseChecker;
import ru.ussgroup.security.trusty.repository.TrustyRepository;

public class KalkanOCSPValidator
implements TrustyOCSPValidator {
    private final KalkanOCSPRequestSender kalkanOCSPRequestSender;
    private final KalkanOCSPResponseChecker kalkanOCSPResponseChecker;

    public KalkanOCSPValidator(String ocspUrl, String ip, TrustyRepository trustyRepository) throws UnknownHostException {
        this.kalkanOCSPRequestSender = new KalkanOCSPRequestSender(ocspUrl, ip, trustyRepository);
        this.kalkanOCSPResponseChecker = new KalkanOCSPResponseChecker(trustyRepository);
    }

    @Override
    public CompletableFuture<TrustyOCSPValidationResult> validateAsync(Set<X509Certificate> certs) {
        KalkanOCSPResponse r = this.kalkanOCSPRequestSender.sendRequest(certs);
        return r.getFutureResponse().thenApplyAsync(ocspResp -> {
            try {
                return this.kalkanOCSPResponseChecker.checkResponse((OCSPResp)ocspResp, r.getNonce());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

