/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.utils;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsResolver {
    static final Logger logger = LoggerFactory.getLogger(DnsResolver.class);
    static ConcurrentHashMap<String, InetAddress> m = new ConcurrentHashMap();

    public static synchronized void addDomainName(String domainName) {
        if (m.get(domainName) == null) {
            try {
                m.put(domainName, InetAddress.getByName(new URI(domainName).getHost()));
            }
            catch (URISyntaxException | UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static InetAddress getInetAddress(String domainName) {
        return m.get(domainName);
    }

    static {
        Thread t = new Thread(){

            @Override
            public void run() {
                while (!1.interrupted()) {
                    for (String domainName : m.keySet()) {
                        try {
                            m.put(domainName, InetAddress.getByName(new URI(domainName).getHost()));
                        }
                        catch (Exception e) {
                            logger.debug("", (Throwable)e);
                        }
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }
}

