/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty.utils;

import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Date;
import ru.ussgroup.security.trusty.TrustyUtils;

public class SignedData {
    private Object id;
    private byte[] data;
    private byte[] signature;
    private X509Certificate cert;
    private Date date;

    public SignedData(String data, String signature, X509Certificate cert) {
        this(null, data, signature, cert);
    }

    public SignedData(Object id, String data, String signature, X509Certificate cert) {
        this(id, data.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(TrustyUtils.removeNewLines(signature)), cert, new Date());
    }

    public SignedData(Object id, String data, String signature, X509Certificate cert, Date date) {
        this(id, data.getBytes(StandardCharsets.UTF_8), Base64.getDecoder().decode(TrustyUtils.removeNewLines(signature)), cert, date);
    }

    public SignedData(byte[] data, byte[] signature, X509Certificate cert) {
        this(null, data, signature, cert, new Date());
    }

    public SignedData(Object id, byte[] data, byte[] signature, X509Certificate cert, Date date) {
        this.id = id;
        this.data = data;
        this.signature = signature;
        this.cert = cert;
        this.date = date;
    }

    public byte[] getData() {
        return this.data;
    }

    public Date getDate() {
        return this.date;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public Object getId() {
        return this.id;
    }
}

