/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import ru.uss.core.exception.JsonParseException;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorCode;
import ru.uss.core.utils.CustomObjectMapper;
import ru.uss.core.utils.ParseResult;

public class JsonHelper {
    private static final String EMPTY = "{}";
    public static final CustomObjectMapper MAPPER = new CustomObjectMapper();
    public static final TypeFactory TYPE_FACTORY = MAPPER.getTypeFactory();

    public static <T> T readValue(String source, Class<T> clazz) {
        try {
            return (T)(JsonHelper.valid(source) ? MAPPER.readValue(source, clazz) : null);
        }
        catch (IOException e) {
            throw JsonHelper.createParseJsonException(e);
        }
    }

    public static <T> ParseResult<T> readValueWithInvalidFormatExceptionSupport(String source, Class<T> clazz) {
        try {
            return ParseResult.success(JsonHelper.valid(source) ? MAPPER.readValue(source, clazz) : null);
        }
        catch (InvalidFormatException ife) {
            StringBuilder resultStringBuilder = new StringBuilder();
            List path = ife.getPath();
            for (int i = 0; i < path.size(); ++i) {
                JsonMappingException.Reference reference = (JsonMappingException.Reference)path.get(i);
                if (reference.getIndex() != -1) {
                    resultStringBuilder.append('[');
                    resultStringBuilder.append(reference.getIndex());
                    resultStringBuilder.append(']');
                    continue;
                }
                if (i != 0) {
                    resultStringBuilder.append('.');
                }
                resultStringBuilder.append(reference.getFieldName());
            }
            return ParseResult.error(new Error(null, resultStringBuilder.toString(), ErrorCode.FIELD_INVALID));
        }
        catch (IOException e) {
            throw JsonHelper.createParseJsonException(e);
        }
    }

    public static <T> T readValue(String source, TypeReference<T> typeRef) {
        try {
            return (T)(JsonHelper.valid(source) ? MAPPER.readValue(source, typeRef) : null);
        }
        catch (IOException e) {
            throw JsonHelper.createParseJsonException(e);
        }
    }

    public static <T> List<T> readValueAsList(String source, Class<T> elementClass) {
        try {
            return JsonHelper.valid(source) ? (List)MAPPER.readValue(source, (JavaType)TYPE_FACTORY.constructCollectionType(List.class, elementClass)) : null;
        }
        catch (IOException e) {
            throw JsonHelper.createParseJsonException(e);
        }
    }

    public static <K, V> Map<K, V> readValueAsMap(String source, Class<K> keyClass, Class<V> valueClass) {
        try {
            return JsonHelper.valid(source) ? (Map)MAPPER.readValue(source, (JavaType)TYPE_FACTORY.constructMapType(Map.class, keyClass, valueClass)) : null;
        }
        catch (IOException e) {
            throw JsonHelper.createParseJsonException(e);
        }
    }

    public static String writeValueAsString(Object object) {
        return JsonHelper.writeValueAsString(object, false);
    }

    public static String writeValueAsStringNotNull(Object object) {
        String res = JsonHelper.writeValueAsString(object);
        return res.compareTo("null") == 0 ? "" : res;
    }

    public static String writeValueAsString(Object object, boolean isPrettyFormat) {
        try {
            if (isPrettyFormat) {
                return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw JsonHelper.createProcessingJsonException((Exception)((Object)e));
        }
    }

    public static void writeValue(OutputStream os, Object object) {
        try {
            MAPPER.writeValue(os, object);
        }
        catch (IOException e) {
            throw JsonHelper.createProcessingJsonException(e);
        }
    }

    public static boolean empty(String source) {
        return !JsonHelper.valid(source) || EMPTY.equals(source);
    }

    private static boolean valid(String source) {
        return source != null && source.length() > 0;
    }

    private static JsonParseException createParseJsonException(Exception cause) {
        return new JsonParseException(cause.getMessage(), cause);
    }

    private static RuntimeException createProcessingJsonException(Exception cause) {
        return new RuntimeException("JSON processing exception", cause);
    }
}

