/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.client;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.cxf.interceptor.AbstractLoggingInterceptor;
import org.springframework.util.Assert;
import ru.uss.core.model.SourceType;
import ru.uss.esf.api1.invoice.InvoiceServiceAPI1;
import ru.uss.esf.api1.session.SessionServiceAPI1;
import ru.uss.esf.api1.upload.UploadInvoiceServiceAPI1;
import ru.uss.esf.client.ClientAPI1;
import ru.uss.esf.client.impl.SerilizableJaxwsService;
import ru.uss.esf.client.impl.SessionClientAPI1;
import ru.uss.esf.model.usermng.BusinessProfileType;

public class ClientFactory {
    public static ClientAPI1 clientAPI1(String wsUrl, String login, String password, String tin, BusinessProfileType profileType, Long projectCode, X509Certificate authCertificate, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        return ClientFactory.clientAPI1(wsUrl, login, password, tin, profileType, projectCode, authCertificate, null, interceptors);
    }

    public static ClientAPI1 clientAPI1(String wsUrl, String login, String password, String tin, BusinessProfileType profileType, Long projectCode, X509Certificate authCertificate) throws Exception {
        return ClientFactory.clientAPI1(wsUrl, login, password, tin, profileType, projectCode, authCertificate, null, null);
    }

    public static ClientAPI1 clientAPI1(String wsUrl, String login, String password, String tin, BusinessProfileType profileType, Long projectCode, X509Certificate authCertificate, SourceType sourceType) throws Exception {
        return ClientFactory.clientAPI1(wsUrl, login, password, tin, profileType, projectCode, authCertificate, sourceType, null);
    }

    public static ClientAPI1 clientAPI1(String wsUrl, String login, String password, String tin, BusinessProfileType profileType, Long projectCode, X509Certificate authCertificate, SourceType sourceType, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        Assert.notNull((Object)wsUrl, (String)"WebService URL can not be null");
        Assert.notNull((Object)login, (String)"Login can not be null");
        Assert.notNull((Object)password, (String)"Password can not be null");
        Assert.notNull((Object)authCertificate, (String)"Auth certificate can not be null");
        return new SessionClientAPI1(ClientFactory.invoiceServiceAPI1(wsUrl, interceptors), ClientFactory.uploadInvoiceServiceAPI1(wsUrl, interceptors), ClientFactory.sessionServiceAPI1(wsUrl, login, password, interceptors), authCertificate, sourceType, tin, profileType, projectCode, true, false);
    }

    static SerilizableJaxwsService<InvoiceServiceAPI1> invoiceServiceAPI1(String wsUrl) throws Exception {
        return ClientFactory.invoiceServiceAPI1(wsUrl, null);
    }

    static SerilizableJaxwsService<InvoiceServiceAPI1> invoiceServiceAPI1(String wsUrl, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        return new SerilizableJaxwsService<InvoiceServiceAPI1>(InvoiceServiceAPI1.class, new URL(wsUrl + "/api1/InvoiceService?wsdl"), "InvoiceService", null, null, false, interceptors);
    }

    static SerilizableJaxwsService<UploadInvoiceServiceAPI1> uploadInvoiceServiceAPI1(String wsUrl, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        return new SerilizableJaxwsService<UploadInvoiceServiceAPI1>(UploadInvoiceServiceAPI1.class, new URL(wsUrl + "/api1/UploadInvoiceService?wsdl"), "UploadInvoiceService", null, null, false, interceptors);
    }

    static SerilizableJaxwsService<SessionServiceAPI1> sessionServiceAPI1(String wsUrl, String login, String password, List<AbstractLoggingInterceptor> interceptors) throws Exception {
        return new SerilizableJaxwsService<SessionServiceAPI1>(SessionServiceAPI1.class, new URL(wsUrl + "/api1/SessionService?wsdl"), "SessionService", login, password, false, interceptors);
    }
}

