/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.esf.model.econtract.EcontractInfo;
import ru.uss.esf.model.econtract.EcontractUploadInfo;
import ru.uss.esf.model.econtract.EcontractVersion;
import ru.uss.esf.model.econtract.abstractecontract.AbstractEcontract;

public class EcontractXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(EcontractXmlUtils.class);

    public static AbstractEcontract xmlToEcontract(String xml, String version) {
        return EcontractXmlUtils.xmlToEcontract(xml, EcontractVersion.valueOf((String)version));
    }

    public static AbstractEcontract xmlToEcontract(String xml, EcontractVersion version) {
        return (AbstractEcontract)JAXBUtils.toObject(xml, version.getClazz());
    }

    public static void unwrapEcontract(EcontractUploadInfo econtractInfo) {
        AbstractEcontract abstractEcontract = EcontractXmlUtils.xmlToEcontract(econtractInfo.getEcontractBody(), econtractInfo.getVersion());
        econtractInfo.setEcontract(abstractEcontract);
    }

    public static void unwrapEcontract(EcontractInfo econtractInfo) {
        AbstractEcontract abstractEcontract = EcontractXmlUtils.xmlToEcontract(econtractInfo.getEcontractBody(), econtractInfo.getVersion());
        econtractInfo.setEcontract(abstractEcontract);
    }

    public static void unwrapEcontractList(List<EcontractUploadInfo> econtractInfoList) {
        ((Stream)econtractInfoList.stream().parallel()).forEach(EcontractXmlUtils::unwrapEcontract);
    }

    public static String econtractToXml(AbstractEcontract abstractEcontract) {
        return JAXBUtils.toXml(abstractEcontract, null, true, true);
    }
}

