/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.springframework.util.Assert;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.xsd.UssSchemaOutputResolver;
import ru.uss.esf.core.utils.xsd.InvoiceVersionObjectFactory;
import ru.uss.esf.model.invoice.abstractinvoice.AbstractInvoice;
import ru.uss.esf.model.invoice.container.InvoiceContainer;
import ru.uss.esf.model.invoice.version.v1.InvoiceV1;
import ru.uss.esf.model.invoice.version.v2.InvoiceV2;

public class InvoiceXmlUtil {
    static final String UTF8_BOM = new String("\ufeff".getBytes(StandardCharsets.UTF_8));
    private static Schema invoiceContainerSchema;
    private static Schema invoiceV1Schema;
    private static Schema invoiceV2Schema;
    private static Pattern TURNOVER_DATE_PATTERN;

    public static synchronized Schema getInvoiceContainerSchema() {
        if (invoiceContainerSchema == null) {
            invoiceContainerSchema = JAXBUtils.scheme(InvoiceContainer.class, sources -> {
                Collections.rotate(sources, 1);
                return (Source[])sources.stream().toArray(Source[]::new);
            });
        }
        return invoiceContainerSchema;
    }

    public static synchronized Schema getInvoiceV1Schema() {
        if (invoiceV1Schema == null) {
            invoiceV1Schema = JAXBUtils.scheme(InvoiceV1.class);
        }
        return invoiceV1Schema;
    }

    public static synchronized Schema getInvoiceV2Schema() {
        if (invoiceV2Schema == null) {
            invoiceV2Schema = JAXBUtils.scheme(InvoiceV2.class);
        }
        return invoiceV2Schema;
    }

    public static String invoiceContainerToXml(InvoiceContainer invoiceContainer) {
        return JAXBUtils.toXml(invoiceContainer, null, false, true);
    }

    public static String invoiceToXml(AbstractInvoice invoice) {
        return JAXBUtils.toXml(invoice, null, true, true);
    }

    public static String invoiceToUnformattedXml(AbstractInvoice invoice) {
        return JAXBUtils.toXml(invoice, null, true, false);
    }

    public static <T> T xmlToInvoice(String xml, Class<T> requiredClass) {
        if (InvoiceV1.class.equals(requiredClass)) {
            return JAXBUtils.toObject(xml.replace("<invoice>", "<v1:invoice xmlns:a=\"abstractInvoice.esf\" xmlns:v1=\"v1.esf\">").replace("</invoice>", "</v1:invoice>"), requiredClass);
        }
        return JAXBUtils.toObject(xml, requiredClass);
    }

    public static String removeBOM(String data) {
        return data != null && data.startsWith(UTF8_BOM) ? data.substring(1) : data;
    }

    public static String convertSchema(String data) {
        Assert.notNull((Object)data, (String)"Source must not be null");
        data = data.replaceAll("v1:invoice", "import_v1:invoice");
        data = data.replaceAll("v2:invoice", "import_v2:invoice");
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n");
        builder.append("<esf:invoiceContainer xmlns:esf=\"esf\" xmlns:import_v1=\"v1.esf\" xmlns:import_v2=\"v2.esf\">");
        builder.append("<invoiceSet>");
        InvoiceXmlUtil.processInvoices(data, builder, "<import_v1:", "</import_v1:invoice>");
        InvoiceXmlUtil.processInvoices(data, builder, "<import_v2:", "</import_v2:invoice>");
        builder.append("</invoiceSet>");
        builder.append("</esf:invoiceContainer>");
        return builder.toString();
    }

    public static String convertSchemaInvoiceV1(String data) {
        Assert.notNull((Object)data, (String)"Source must not be null");
        if (data.startsWith("<import_v2:invoice")) {
            return data;
        }
        data = data.replaceFirst("<signature>[^<]*</signature>", "");
        Matcher matcher = TURNOVER_DATE_PATTERN.matcher(data = data.replaceFirst("<signatureType>(COMPANY|OPERATOR)</signatureType>", ""));
        if (matcher.find()) {
            String turnoverDate = matcher.group();
            if ((data = data.replaceFirst("<turnoverDate>\\d{2}\\.\\d{2}\\.\\d{4}</turnoverDate>", "")).contains("</relatedInvoice>")) {
                data = data.replaceFirst("(</relatedInvoice>)", "$0" + turnoverDate);
            } else if (data.contains("</operatorFullname>")) {
                data = data.replaceFirst("(</operatorFullname>)", "$0" + turnoverDate);
            }
        }
        return data;
    }

    public static UssSchemaOutputResolver createInvoiceXsdResolver(Class<? extends AbstractInvoice> clazz) {
        return JAXBUtils.resolver(clazz, InvoiceXmlUtil.getInvoiceObjectFactory(clazz));
    }

    public static Class<?> getInvoiceObjectFactory(Class<? extends AbstractInvoice> clazz) {
        if (clazz.equals(InvoiceV1.class) || clazz.equals(InvoiceV2.class)) {
            return InvoiceVersionObjectFactory.class;
        }
        throw new IllegalStateException();
    }

    private static void processInvoices(String data, StringBuilder builder, String startTag, String endTag) {
        int endTagIndex;
        int startTagIndex;
        int position = 0;
        do {
            startTagIndex = data.indexOf(startTag, position);
            endTagIndex = data.indexOf(endTag, position);
            if (startTagIndex != -1 && endTagIndex != -1) {
                String invoiceXml = data.substring(startTagIndex, endTagIndex + endTag.length());
                builder.append(InvoiceXmlUtil.convertSchemaInvoiceV1(invoiceXml));
            }
            position = endTagIndex + endTag.length();
        } while (startTagIndex != -1 && endTagIndex != -1);
    }

    public static void main(String[] args) throws Exception {
    }

    static {
        TURNOVER_DATE_PATTERN = Pattern.compile("(<turnoverDate>\\d{2}\\.\\d{2}\\.\\d{4}</turnoverDate>)");
    }
}

