/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.core.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.XmlParseException;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.xsd.UssSchemaOutputResolver;
import ru.uss.esf.core.utils.xsd.SntVersionObjectFactory;
import ru.uss.esf.model.snt.SntInfo;
import ru.uss.esf.model.snt.SntOgdMarksType;
import ru.uss.esf.model.snt.SntOgdMarksVersionMapper;
import ru.uss.esf.model.snt.SntUploadInfo;
import ru.uss.esf.model.snt.SntVersion;
import ru.uss.esf.model.snt.abstractsnt.AbstractSnt;
import ru.uss.esf.model.snt.abstractsnt.AbstractSntOgdMarks;
import ru.uss.esf.model.snt.container.SntContainer;
import ru.uss.esf.model.snt.version.v1.SntV1;

public class SntXmlUtils {
    private static final Logger logger = LoggerFactory.getLogger(SntXmlUtils.class);
    private static Schema sntContainerSchema;
    private static Schema sntV1Schema;
    private static Schema sntOgdMarksV1Schema;

    public static synchronized Schema getSntContainerSchema() {
        if (sntContainerSchema == null) {
            sntContainerSchema = JAXBUtils.scheme(SntContainer.class, sources -> {
                Collections.rotate(sources, 1);
                return (Source[])sources.stream().toArray(Source[]::new);
            });
        }
        return sntContainerSchema;
    }

    public static synchronized Schema getSntV1Schema() {
        if (sntV1Schema == null) {
            sntV1Schema = JAXBUtils.scheme(SntV1.class);
        }
        return sntV1Schema;
    }

    private static Unmarshaller createUnmarshaller(Class<?> clazz, Schema schema) {
        try {
            JAXBContext sntV1Context = JAXBUtils.context(clazz);
            Unmarshaller unmarshallerSntV1 = sntV1Context.createUnmarshaller();
            unmarshallerSntV1.setSchema(schema);
            unmarshallerSntV1.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            return unmarshallerSntV1;
        }
        catch (JAXBException e) {
            throw new XmlParseException("Error, creating Unmarshaller for SntV1", (Exception)((Object)e));
        }
    }

    public static SntContainer readSntContainer(String containerXml) {
        return (SntContainer)JAXBUtils.toObjectWithSchemeValidation(containerXml, SntXmlUtils.createUnmarshaller(SntContainer.class, SntXmlUtils.getSntContainerSchema()));
    }

    public static void unwrapSnt(SntUploadInfo sntInfo) {
        try {
            AbstractSnt snt = null;
            if (SntVersion.SntV1 != sntInfo.getVersion()) {
                throw new IllegalArgumentException("Unknown version of Snt (" + sntInfo.getVersion() + ")");
            }
            snt = (AbstractSnt)JAXBUtils.toObjectWithSchemeValidation(sntInfo.getSntBody(), SntXmlUtils.createUnmarshaller(SntV1.class, SntXmlUtils.getSntV1Schema()));
            sntInfo.setSnt(snt);
        }
        catch (XmlParseException xe) {
            throw xe;
        }
        catch (Exception e) {
            logger.error("Can`t unwrap sntInfo", (Throwable)e);
            throw new XmlParseException("Can`t unwrap sntInfo", e);
        }
    }

    public static void unwrapSnt(SntInfo sntInfo) {
        try {
            AbstractSnt snt = null;
            if (SntVersion.SntV1 != sntInfo.getVersion()) {
                throw new IllegalArgumentException("Unknown version of Snt (" + sntInfo.getVersion() + ")");
            }
            snt = (AbstractSnt)JAXBUtils.toObjectWithSchemeValidation(sntInfo.getDocumentInfo().getSntBody(), SntXmlUtils.createUnmarshaller(SntV1.class, SntXmlUtils.getSntV1Schema()));
            sntInfo.getDocumentInfo().setSnt(snt);
        }
        catch (XmlParseException xe) {
            throw xe;
        }
        catch (Exception e) {
            logger.error("Can`t unwrap sntInfo", (Throwable)e);
            throw new XmlParseException("Can`t unwrap sntInfo", e);
        }
    }

    public static void unwrapSntList(List<SntUploadInfo> sntInfoList) {
        for (SntUploadInfo sntInfo : sntInfoList) {
            SntXmlUtils.unwrapSnt(sntInfo);
        }
    }

    public static void unwrapSntInfoList(List<SntInfo> sntInfoList) {
        for (SntInfo sntInfo : sntInfoList) {
            SntXmlUtils.unwrapSnt(sntInfo);
        }
    }

    public static AbstractSnt xmlToSnt(String xml, SntVersion version) {
        return (AbstractSnt)JAXBUtils.toObject(xml, version.getSntClass());
    }

    public static AbstractSntOgdMarks xmlToOgdMarks(String xml, SntVersion version, SntOgdMarksType ogdMarkType) {
        return (AbstractSntOgdMarks)JAXBUtils.toObject(xml, SntOgdMarksVersionMapper.getClassByVersion((SntVersion)version, (SntOgdMarksType)ogdMarkType));
    }

    public static String sntToXml(AbstractSnt snt) {
        return JAXBUtils.toXml(snt, null, true, true);
    }

    public static UssSchemaOutputResolver createSntXsdResolver(Class<? extends AbstractSnt> clazz) {
        return JAXBUtils.resolver(clazz, SntXmlUtils.getSntObjectFactory(clazz));
    }

    public static Class<?> getSntObjectFactory(Class<? extends AbstractSnt> clazz) {
        if (clazz.equals(SntV1.class)) {
            return SntVersionObjectFactory.class;
        }
        throw new IllegalStateException();
    }

    public static SntContainer unmarshalSntContainer(String filePath) throws Exception {
        try {
            String data = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
            SntContainer sntContainer = JAXBUtils.toObject(data, SntContainer.class);
            return sntContainer;
        }
        finally {
            new File(filePath).delete();
        }
    }
}

