/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.ndsbc.utils;

import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.exception.XmlParseException;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.esf.model.ndsbc.ks.KsAccountVersion;
import ru.uss.esf.model.ndsbc.ks.abstractndsbc.KsAbstractAccount;
import ru.uss.esf.model.ndsbc.ks.abstractndsbc.KsAbstractStatement;
import ru.uss.esf.model.ndsbc.ks.abstractndsbc.KsAbstractVerification;
import ru.uss.esf.model.ndsbc.ks.version.v1.KsAccountV1;
import ru.uss.esf.model.ndsbc.ks.version.v1.KsStatementV1;
import ru.uss.esf.model.ndsbc.ks.version.v1.KsVerificationV1;
import ru.uss.ndsbc.api1.ks.KsAccountUploadInfo;
import ru.uss.ndsbc.api1.ks.KsStatementUploadInfo;
import ru.uss.ndsbc.api1.ks.KsVerificationRequest;

public class KsXmlUtils {
    public static final Logger log = LoggerFactory.getLogger(KsXmlUtils.class);
    private static Schema ksAccountV1Schema;
    private static Schema ksStatementV1Schema;
    private static Schema ksVerificationV1Schema;

    public static void unwrapKsAccount(List<KsAccountUploadInfo> list) {
        for (KsAccountUploadInfo ksAccountUploadInfo : list) {
            KsXmlUtils.unwrapKsAccount(ksAccountUploadInfo);
        }
    }

    public static void unwrapKsStatement(List<KsStatementUploadInfo> list) {
        for (KsStatementUploadInfo ksStatementUploadInfo : list) {
            KsXmlUtils.unwrapKsStatement(ksStatementUploadInfo);
        }
    }

    public static void unwrapKsAccount(KsAccountUploadInfo uploadInfo) {
        try {
            if (KsAccountVersion.KS_V1 != uploadInfo.getVersion()) {
                throw new IllegalArgumentException("Unknown version of KSAccountData (" + uploadInfo.getVersion() + ")");
            }
            KsAbstractAccount accountData = (KsAbstractAccount)JAXBUtils.toObjectWithSchemeValidation(uploadInfo.getAccountBody(), KsXmlUtils.createUnmarshaller(KsAccountV1.class, KsXmlUtils.getKsAccountV1Schema()));
            uploadInfo.setKsAbstractAccountData(accountData);
        }
        catch (XmlParseException xe) {
            throw xe;
        }
        catch (Exception e) {
            log.error("Can`t unwrap KsAccountInfo", (Throwable)e);
            throw new XmlParseException("Can`t unwrap KsAccountInfo", e);
        }
    }

    public static void unwrapKsStatement(KsStatementUploadInfo uploadInfo) {
        try {
            if (KsAccountVersion.KS_V1 != uploadInfo.getVersion()) {
                throw new IllegalArgumentException("Unknown version of KsStatementData (" + uploadInfo.getVersion() + ")");
            }
            KsAbstractStatement statementData = (KsAbstractStatement)JAXBUtils.toObjectWithSchemeValidation(uploadInfo.getStatementBody(), KsXmlUtils.createUnmarshaller(KsStatementV1.class, KsXmlUtils.getKsStatementV1Schema()));
            uploadInfo.setKsAbstractStatementData(statementData);
        }
        catch (XmlParseException xe) {
            throw xe;
        }
        catch (Exception e) {
            log.error("Can`t unwrap KsStatementUploadInfo", (Throwable)e);
            throw new XmlParseException("Can`t unwrap KsStatementUploadInfo", e);
        }
    }

    public static void unwrapKsVerification(KsVerificationRequest verificationRequest) {
        try {
            if (KsAccountVersion.KS_V1 != verificationRequest.getVersion()) {
                throw new IllegalArgumentException("Unknown version of KsVerification (" + verificationRequest.getVersion() + ")");
            }
            KsAbstractVerification abstractVerification = (KsAbstractVerification)JAXBUtils.toObjectWithSchemeValidation(verificationRequest.getVerificationBody(), KsXmlUtils.createUnmarshaller(KsVerificationV1.class, KsXmlUtils.getKsVerificationV1Schema()));
            verificationRequest.setVerification(abstractVerification);
        }
        catch (XmlParseException xe) {
            throw xe;
        }
        catch (Exception e) {
            log.error("Can`t unwrap KsVerificationRequest", (Throwable)e);
            throw new XmlParseException("Can`t unwrap KsVerificationRequest", e);
        }
    }

    public static synchronized Schema getKsAccountV1Schema() {
        if (ksAccountV1Schema == null) {
            ksAccountV1Schema = JAXBUtils.scheme(KsAccountV1.class);
        }
        return ksAccountV1Schema;
    }

    public static synchronized Schema getKsStatementV1Schema() {
        if (ksStatementV1Schema == null) {
            ksStatementV1Schema = JAXBUtils.scheme(KsStatementV1.class);
        }
        return ksStatementV1Schema;
    }

    public static synchronized Schema getKsVerificationV1Schema() {
        if (ksVerificationV1Schema == null) {
            ksVerificationV1Schema = JAXBUtils.scheme(KsVerificationV1.class);
        }
        return ksVerificationV1Schema;
    }

    private static Unmarshaller createUnmarshaller(Class<?> clazz, Schema schema) {
        try {
            JAXBContext context = JAXBUtils.context(clazz);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(schema);
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            return unmarshaller;
        }
        catch (JAXBException e) {
            throw new XmlParseException("Error, creating Unmarshaller for ", (Exception)((Object)e));
        }
    }
}

