/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.api.ofd;

import java.util.List;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.model.ErrorCode;
import ru.uss.vstore.api.ofd.OfdBalanceQueryStatus;
import ru.uss.vstore.model.ofd.OfdBalance;
import ru.uss.vstore.model.web.store.Balance;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OfdBalanceStatus")
@Documentation(value="\u0414\u0430\u043d\u043d\u044b\u0435 \u043e\u0431 \u043e\u0441\u0442\u0430\u0442\u043a\u0430\u0445 \u043d\u0430 \u0412\u0421")
public class OfdBalanceStatus {
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u043d\u0438\u043a\u0430-\u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432")
    private String tin;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 \u041e\u0441\u0442\u0430\u0442\u043a\u0430")
    private Long lastBalanceId;
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u043b\u043e\u043a \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c")
    private Boolean lastBlock;
    @XmlElementWrapper(required=false)
    @XmlElement(name="balance")
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0442\u0435\u043a\u0443\u0449\u0438\u0445 \u041e\u0441\u0442\u0430\u0442\u043a\u0430\u0445")
    private List<OfdBalance> balances;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String errorCode;

    public OfdBalanceStatus(String tin, Long lastBalanceId, Boolean lastBlock, List<Balance> balances, ErrorCode errorCode) {
        this.tin = tin;
        this.lastBalanceId = lastBalanceId;
        this.lastBlock = lastBlock;
        this.balances = OfdBalance.from(balances);
        this.errorCode = errorCode.name();
    }

    public OfdBalanceStatus() {
    }

    public static OfdBalanceStatus of(OfdBalanceQueryStatus ofdBalanceQueryStatus, ErrorCode errorCode) {
        return new OfdBalanceStatus(ofdBalanceQueryStatus.getTin(), ofdBalanceQueryStatus.getLastBalanceId(), false, null, errorCode);
    }

    public static OfdBalanceStatus of(OfdBalanceQueryStatus queryStatus, List<Balance> balances) {
        OfdBalanceStatus balanceStatus = new OfdBalanceStatus();
        balanceStatus.setLastBlock(balances.size() <= queryStatus.getLimit());
        if (!balanceStatus.getLastBlock().booleanValue()) {
            balances.remove(balances.size() - 1);
        }
        balanceStatus.setTin(queryStatus.getTin());
        balanceStatus.setBalances(OfdBalance.from(balances));
        balanceStatus.setLastBalanceId(balances.stream().map(u -> u.getBalanceId()).max(Long::compareTo).orElse(queryStatus.getLastBalanceId()));
        return balanceStatus;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public Long getLastBalanceId() {
        return this.lastBalanceId;
    }

    public void setLastBalanceId(Long lastBalanceId) {
        this.lastBalanceId = lastBalanceId;
    }

    public Boolean getLastBlock() {
        return this.lastBlock;
    }

    public void setLastBlock(Boolean lastBlock) {
        this.lastBlock = lastBlock;
    }

    public List<OfdBalance> getBalances() {
        return this.balances;
    }

    public void setBalances(List<OfdBalance> balances) {
        this.balances = balances;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

