/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.api.ofd;

import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.model.ErrorCode;
import ru.uss.vstore.api.ofd.OfdBalanceQueryUpdates;
import ru.uss.vstore.model.ofd.OfdBalanceUpdate;
import ru.uss.vstore.model.web.store.BalanceUpdate;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OfdBalanceUpdates")
@Documentation(value="\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u043e\u0441\u0442\u0430\u0442\u043a\u0430\u0445 \u041d\u041f")
public class OfdBalanceUpdates {
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u043d\u0430\u043b\u043e\u0433\u043e\u043f\u043b\u0430\u0442\u0435\u043b\u044c\u043d\u0438\u043a\u0430-\u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432")
    private String tin;
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0441\u0430\u043c\u043e\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u044d\u0442\u043e\u043c \u0431\u043b\u043e\u043a\u0435 (\u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u043e\u0439)")
    private Date lastEventDate;
    @XmlElement(required=false)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u041e\u0441\u0442\u0430\u0442\u043a\u0430 (balanceId) \u0432 \u043e\u0442\u0432\u0435\u0442\u0435")
    private Long lastBalanceId;
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u043b\u043e\u043a \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u043c")
    private Boolean lastBlock;
    @XmlElementWrapper(required=false)
    @XmlElement(name="update")
    @Documentation(value="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u0430\u0445")
    private List<OfdBalanceUpdate> updates;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438")
    private String errorCode;

    public static OfdBalanceUpdates of(OfdBalanceQueryUpdates queryUpdates, List<BalanceUpdate> updates) {
        OfdBalanceUpdates balanceUpdates = new OfdBalanceUpdates();
        balanceUpdates.setUpdates(OfdBalanceUpdate.fromUpdates(updates));
        balanceUpdates.setLastBlock(updates.size() <= queryUpdates.getLimit());
        if (!balanceUpdates.getLastBlock().booleanValue()) {
            updates.remove(updates.size() - 1);
        }
        balanceUpdates.setTin(queryUpdates.getTin());
        balanceUpdates.setLastEventDate(updates.stream().map(u -> u.getUpdateDate()).max(Date::compareTo).orElse(queryUpdates.getLastEventDate()));
        balanceUpdates.setLastBalanceId(updates.stream().map(u -> u.getBalanceId()).max(Long::compareTo).orElse(queryUpdates.getLastBalanceId()));
        return balanceUpdates;
    }

    public static OfdBalanceUpdates of(OfdBalanceQueryUpdates queryUpdates, ErrorCode errorCode) {
        OfdBalanceUpdates balanceUpdates = new OfdBalanceUpdates();
        balanceUpdates.setTin(queryUpdates.getTin());
        balanceUpdates.setLastBalanceId(queryUpdates.getLastBalanceId());
        balanceUpdates.setLastBlock(false);
        balanceUpdates.setLastEventDate(queryUpdates.getLastEventDate());
        balanceUpdates.setErrorCode(errorCode.name());
        return balanceUpdates;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public Date getLastEventDate() {
        return this.lastEventDate;
    }

    public void setLastEventDate(Date lastEventDate) {
        this.lastEventDate = lastEventDate;
    }

    public Long getLastBalanceId() {
        return this.lastBalanceId;
    }

    public void setLastBalanceId(Long lastBalanceId) {
        this.lastBalanceId = lastBalanceId;
    }

    public Boolean getLastBlock() {
        return this.lastBlock;
    }

    public void setLastBlock(Boolean lastBlock) {
        this.lastBlock = lastBlock;
    }

    public List<OfdBalanceUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(List<OfdBalanceUpdate> updates) {
        this.updates = updates;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }
}

