/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.utils;

import java.io.Reader;
import java.io.StringReader;
import java.security.SignatureException;
import javax.security.auth.x500.X500PrivateCredential;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import ru.uss.core.utils.JAXBUtils;
import ru.uss.core.utils.SignatureHelper;
import ru.uss.vstore.model.uform.abstractuform.AbstractUForm;
import ru.uss.vstore.model.uform.version.UFormVersionMapper;
import ru.uss.vstore.utils.UFormXmlUtils;

public class UFormSignatureHelper
extends SignatureHelper {
    public static String sign(AbstractUForm uForm, X500PrivateCredential certificate) throws SignatureException {
        return UFormSignatureHelper.sign(UFormSignatureHelper.extractSignatureData(uForm), certificate);
    }

    public static String extractSignatureData(AbstractUForm uForm) {
        try {
            return UFormXmlUtils.uFormToXml(uForm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends AbstractUForm> T cloneUForm(T uForm) {
        try {
            Class uttnClass = UFormVersionMapper.getClassByVersion((String)"UFormV1");
            JAXBContext context = JAXBUtils.context(uttnClass);
            String xml = JAXBUtils.toXml(uForm, null, true, false);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)((AbstractUForm)unmarshaller.unmarshal((Reader)new StringReader(xml)));
        }
        catch (JAXBException e) {
            throw new RuntimeException("UForm signable copy creation failed", e);
        }
    }

    public static String toXML(Object object) {
        return JAXBUtils.toXml(object, null, true, false);
    }

    public static void main(String[] args) {
    }
}

