/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan;

import java.util.HashMap;
import java.util.Map;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Storage {
    KAZTOKEN("AKKaztokenStore", KNCAObjectIdentifiers.kaztoken, true),
    KZIDCARD("AKKZIDCardStore", KNCAObjectIdentifiers.kzidcard, true),
    ETOKEN_72K("AKEToken72KStore", KNCAObjectIdentifiers.etoken_java, true),
    ETOKEN_5110("AKEToken5110Store", KNCAObjectIdentifiers.etoken5110, true),
    JACARTA("AKJaCartaStore", KNCAObjectIdentifiers.jacarta, true),
    AKEY("AKAKEYStore", KNCAObjectIdentifiers.akey, true),
    PKCS12("PKCS12", KNCAObjectIdentifiers.pkcs12, false),
    JKS("JKS", KNCAObjectIdentifiers.jks, false),
    CERTEX_CLOUD("ABCloudServiceStore", KNCAObjectIdentifiers.did, true);

    private final String name;
    private final boolean token;
    private final DERObjectIdentifier oid;
    private static final Map<String, Storage> storageMap;
    private static final Map<String, Storage> oidToStorage;

    private Storage(String name, DERObjectIdentifier oid, boolean token) {
        this.name = name;
        this.oid = oid;
        this.token = token;
    }

    public String getName() {
        return this.name;
    }

    public boolean isToken() {
        return this.token;
    }

    public DERObjectIdentifier getOid() {
        return this.oid;
    }

    public static Storage get(String storageName) {
        return storageMap.get(storageName);
    }

    public static Storage getByOid(String storageOid) {
        return oidToStorage.get(storageOid);
    }

    static {
        storageMap = new HashMap<String, Storage>();
        oidToStorage = new HashMap<String, Storage>();
        storageMap.put("AKKaztokenStore", KAZTOKEN);
        storageMap.put("AKKZIDCardStore", KZIDCARD);
        storageMap.put("AKEToken72KStore", ETOKEN_72K);
        storageMap.put("AKEToken5110Store", ETOKEN_5110);
        storageMap.put("AKJaCartaStore", JACARTA);
        storageMap.put("PKCS12", PKCS12);
        storageMap.put("JKS", JKS);
        storageMap.put("AKAKEYStore", AKEY);
        storageMap.put("ABCloudServiceStore", CERTEX_CLOUD);
        oidToStorage.put(KAZTOKEN.getOid().getId(), KAZTOKEN);
        oidToStorage.put(KZIDCARD.getOid().getId(), KZIDCARD);
        oidToStorage.put(ETOKEN_72K.getOid().getId(), ETOKEN_72K);
        oidToStorage.put(ETOKEN_5110.getOid().getId(), ETOKEN_5110);
        oidToStorage.put(JACARTA.getOid().getId(), JACARTA);
        oidToStorage.put(PKCS12.getOid().getId(), PKCS12);
        oidToStorage.put(JKS.getOid().getId(), JKS);
        oidToStorage.put(AKEY.getOid().getId(), AKEY);
        oidToStorage.put(CERTEX_CLOUD.getOid().getId(), CERTEX_CLOUD);
    }
}

