/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.asn1.x509;

import java.math.BigInteger;
import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DERBoolean;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.x509.X509Extension;

public class BasicConstraints
extends ASN1Encodable {
    DERBoolean cA = new DERBoolean(false);
    DERInteger pathLenConstraint = null;

    public static BasicConstraints getInstance(ASN1TaggedObject obj, boolean explicit) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static BasicConstraints getInstance(Object obj) {
        if (obj == null || obj instanceof BasicConstraints) {
            return (BasicConstraints)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new BasicConstraints((ASN1Sequence)obj);
        }
        if (obj instanceof X509Extension) {
            return BasicConstraints.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public BasicConstraints(ASN1Sequence seq) {
        if (seq.size() == 0) {
            this.cA = null;
            this.pathLenConstraint = null;
        } else {
            if (seq.getObjectAt(0) instanceof DERBoolean) {
                this.cA = DERBoolean.getInstance(seq.getObjectAt(0));
            } else {
                this.cA = null;
                this.pathLenConstraint = DERInteger.getInstance(seq.getObjectAt(0));
            }
            if (seq.size() > 1) {
                if (this.cA != null) {
                    this.pathLenConstraint = DERInteger.getInstance(seq.getObjectAt(1));
                } else {
                    throw new IllegalArgumentException("wrong sequence in constructor");
                }
            }
        }
    }

    public BasicConstraints(boolean cA, int pathLenConstraint) {
        if (cA) {
            this.cA = new DERBoolean(cA);
            this.pathLenConstraint = new DERInteger(pathLenConstraint);
        } else {
            this.cA = null;
            this.pathLenConstraint = null;
        }
    }

    public BasicConstraints(boolean cA) {
        this.cA = cA ? new DERBoolean(true) : null;
        this.pathLenConstraint = null;
    }

    public BasicConstraints(int pathLenConstraint) {
        this.cA = new DERBoolean(true);
        this.pathLenConstraint = new DERInteger(pathLenConstraint);
    }

    public boolean isCA() {
        return this.cA != null && this.cA.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.pathLenConstraint != null) {
            return this.pathLenConstraint.getValue();
        }
        return null;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.cA != null) {
            v.add(this.cA);
        }
        if (this.pathLenConstraint != null) {
            v.add(this.pathLenConstraint);
        }
        return new DERSequence(v);
    }

    public String toString() {
        if (this.pathLenConstraint == null) {
            if (this.cA == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.pathLenConstraint.getValue();
    }
}

