/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import kz.gov.pki.kalkan.crypto.AsymmetricCipherKeyPair;
import kz.gov.pki.kalkan.crypto.AsymmetricCipherKeyPairGenerator;
import kz.gov.pki.kalkan.crypto.KeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.ECDomainParameters;
import kz.gov.pki.kalkan.crypto.params.ECKeyGenerationParameters;
import kz.gov.pki.kalkan.crypto.params.ECPrivateKeyParameters;
import kz.gov.pki.kalkan.crypto.params.ECPublicKeyParameters;
import kz.gov.pki.kalkan.math.ec.ECConstants;
import kz.gov.pki.kalkan.math.ec.ECPoint;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, this.random)).equals(ZERO) || d.compareTo(n) >= 0) {
        }
        ECPoint Q2 = this.params.getG().multiply(d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q2, this.params), new ECPrivateKeyParameters(d, this.params));
    }
}

