/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.exception;

public class GeneralException
extends Exception {
    private String errCode = null;
    private String classname = null;
    private String method = null;
    private String message = null;
    private GeneralException previous = null;
    private String separator = "\n";

    public GeneralException(String message) {
        this.message = message;
    }

    public GeneralException(String errCode, String classname, String method, String message, GeneralException previous) {
        this.errCode = errCode;
        this.classname = classname;
        this.method = method;
        this.message = message;
        this.previous = previous;
    }

    public GeneralException(String[] errArr, String classname, String method, GeneralException previous) {
        this.errCode = errArr[0];
        this.classname = classname;
        this.method = method;
        this.message = errArr[1];
        this.previous = previous;
    }

    public String traceBack() {
        return this.traceBackToTop("\n");
    }

    public String traceBack(String sep) {
        this.separator = sep;
        int level = 0;
        GeneralException e = this;
        String text = this.line("Calling sequence (top to bottom)");
        while (e != null) {
            text = text + this.line("--level " + ++level + "--------------------------------------");
            text = text + this.line("Class/Method: " + e.classname + "/" + e.method);
            text = text + this.line("Error code  : " + e.getErrCode());
            text = text + this.line("Message     : " + e.getMessage());
            e = e.previous;
        }
        return text;
    }

    public String traceBackToTop(String sep) {
        this.separator = sep;
        GeneralException e = this;
        String text = "";
        while (e != null) {
            text = this.line("at " + e.classname + "." + e.method + ", code " + e.getErrCode() + ", \"" + e.getMessage() + "\"") + text;
            e = e.previous;
        }
        text = this.line("----------------------------------------------") + text;
        text = this.line("Calling sequence (from bottom to top)") + text;
        return text;
    }

    private String line(String s) {
        return s + this.separator;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getMessage() {
        return this.message;
    }

    public GeneralException getTopException() {
        int level = 0;
        GeneralException e = this;
        GeneralException ret = null;
        while (e != null) {
            ++level;
            ret = e;
            e = e.previous;
        }
        return ret;
    }

    public String getTopErrCode() {
        int level = 0;
        GeneralException e = this;
        String ret = null;
        while (e != null) {
            ++level;
            ret = e.getErrCode();
            e = e.previous;
        }
        return ret;
    }

    public String getTopMessage() {
        int level = 0;
        GeneralException e = this;
        String ret = null;
        while (e != null) {
            ++level;
            ret = e.getMessage();
            e = e.previous;
        }
        return ret;
    }
}

