/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PrivateKeyInfo;
import kz.gov.pki.kalkan.asn1.pkcs.RSAPrivateKeyStructure;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x9.X9ObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.JCEECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCEECPublicKey;
import kz.gov.pki.kalkan.jce.provider.JCEKalkanECPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPrivateCrtKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPrivateKey;
import kz.gov.pki.kalkan.jce.provider.JCERSAPublicKey;
import kz.gov.pki.kalkan.jce.provider.JDKGOST3410PrivateKey;
import kz.gov.pki.kalkan.jce.provider.JDKGOST3410PublicKey;
import kz.gov.pki.kalkan.jce.provider.JDKKalkanRSAPrivateKey;
import kz.gov.pki.kalkan.jce.provider.RSAUtil;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15.EcGost3410_2015PrivateKey;
import kz.gov.pki.kalkan.jce.provider.asymmetric.ecgost15.EcGost3410_2015PublicKey;
import kz.gov.pki.kalkan.jce.spec.ECKalkanPrivateKeySpec;
import kz.gov.pki.kalkan.jce.spec.ECPrivateKeySpec;
import kz.gov.pki.kalkan.jce.spec.GOST3410PrivateKeySpec;
import kz.gov.pki.kalkan.jce.spec.GOST3410PublicKeySpec;
import kz.gov.pki.kalkan.jce.spec.KalkanRSAPrivateKeySpec;

public abstract class JDKKeyFactory
extends KeyFactorySpi {
    protected boolean elGamalFactory = false;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        if (keySpec instanceof ECKalkanPrivateKeySpec) {
            return new JCEKalkanECPrivateKey((ECKalkanPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof KalkanRSAPrivateKeySpec) {
            return new JDKKalkanRSAPrivateKey((KalkanRSAPrivateKeySpec)keySpec);
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                return JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e.toString());
            }
        }
        throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
    }

    protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
        if (spec.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(RSAPublicKeySpec.class) && key instanceof RSAPublicKey) {
            RSAPublicKey k = (RSAPublicKey)key;
            return new RSAPublicKeySpec(k.getModulus(), k.getPublicExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateKeySpec.class) && key instanceof RSAPrivateKey) {
            RSAPrivateKey k = (RSAPrivateKey)key;
            return new RSAPrivateKeySpec(k.getModulus(), k.getPrivateExponent());
        }
        if (spec.isAssignableFrom(RSAPrivateCrtKeySpec.class) && key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getPrimeP(), k.getPrimeQ(), k.getPrimeExponentP(), k.getPrimeExponentQ(), k.getCrtCoefficient());
        }
        if (spec.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
            DHPrivateKey k = (DHPrivateKey)key;
            return new DHPrivateKeySpec(k.getX(), k.getParams().getP(), k.getParams().getG());
        }
        if (spec.isAssignableFrom(DHPublicKeySpec.class) && key instanceof DHPublicKey) {
            DHPublicKey k = (DHPublicKey)key;
            return new DHPublicKeySpec(k.getY(), k.getParams().getP(), k.getParams().getG());
        }
        if (spec.isAssignableFrom(ECKalkanPrivateKeySpec.class) && key.getFormat().equals("PLAIN")) {
            return new ECKalkanPrivateKeySpec(key.getEncoded());
        }
        if (spec.isAssignableFrom(KalkanRSAPrivateKeySpec.class) && key.getFormat().equals("PLAIN")) {
            return new KalkanRSAPrivateKeySpec(key.getEncoded());
        }
        throw new RuntimeException("not implemented yet " + key + " " + spec);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPublicKey) {
            return new JCERSAPublicKey((RSAPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return new JCERSAPrivateCrtKey((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return new JCERSAPrivateKey((RSAPrivateKey)key);
        }
        throw new InvalidKeyException("key type unknown");
    }

    public static PublicKey createPublicKeyFromDERStream(byte[] in) throws IOException {
        return JDKKeyFactory.createPublicKeyFromPublicKeyInfo(new SubjectPublicKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(in)));
    }

    static PublicKey createPublicKeyFromPublicKeyInfo(SubjectPublicKeyInfo info) {
        DERObjectIdentifier algOid = info.getAlgorithmId().getObjectId();
        if (RSAUtil.isRsaOid(algOid)) {
            return new JCERSAPublicKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPublicKey(info);
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new JDKGOST3410PublicKey(info);
        }
        if (algOid.equals(KNCAObjectIdentifiers.gost34310_2004) || algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001) || algOid.equals(CryptoProObjectIdentifiers.gostR34310_2004) || algOid.equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004)) {
            return new JCEECPublicKey(info);
        }
        if (algOid.equals(KNCAObjectIdentifiers.gost3410_2015_256) || algOid.equals(KNCAObjectIdentifiers.gost3410_2015_512)) {
            return new EcGost3410_2015PublicKey(info);
        }
        throw new RuntimeException("algorithm identifier " + algOid + " in key not recognised");
    }

    protected static PrivateKey createPrivateKeyFromDERStream(byte[] in) throws IOException {
        return JDKKeyFactory.createPrivateKeyFromPrivateKeyInfo(new PrivateKeyInfo((ASN1Sequence)ASN1Object.fromByteArray(in)));
    }

    static PrivateKey createPrivateKeyFromPrivateKeyInfo(PrivateKeyInfo info) {
        DERObjectIdentifier algOid = info.getAlgorithmId().getObjectId();
        if (RSAUtil.isRsaOid(algOid)) {
            return new JCERSAPrivateCrtKey(info);
        }
        if (algOid.equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            return new JCEECPrivateKey(info);
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_94)) {
            return new JDKGOST3410PrivateKey(info);
        }
        if (algOid.equals(CryptoProObjectIdentifiers.gostR3410_2001) || algOid.equals(KNCAObjectIdentifiers.gost34310_2004) || algOid.equals(CryptoProObjectIdentifiers.gostR34310_2004)) {
            return new JCEECPrivateKey(info);
        }
        if (algOid.equals(KNCAObjectIdentifiers.gost3410_2015_256) || algOid.equals(KNCAObjectIdentifiers.gost3410_2015_512)) {
            return new EcGost3410_2015PrivateKey(info);
        }
        throw new RuntimeException("algorithm identifier " + algOid + " in key not recognised");
    }

    public static class X509
    extends JDKKeyFactory {
    }

    public static class ECGOST3410_2015
    extends EC {
        public ECGOST3410_2015() {
            super("ECGOST3410-2015");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST34310");
        }
    }

    public static class EC
    extends JDKKeyFactory {
        String algorithm;

        public EC() {
            this("EC");
        }

        public EC(String algorithm) {
            this.algorithm = algorithm;
        }

        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (ECPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof java.security.spec.ECPrivateKeySpec) {
                return new JCEECPrivateKey(this.algorithm, (java.security.spec.ECPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof ECKalkanPrivateKeySpec) {
                return new JCEKalkanECPrivateKey((ECKalkanPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof X509EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPublicKeyFromDERStream(((X509EncodedKeySpec)keySpec).getEncoded());
                }
                catch (Exception e) {
                    throw new InvalidKeySpecException(e.toString());
                }
            }
            if (keySpec instanceof kz.gov.pki.kalkan.jce.spec.ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (kz.gov.pki.kalkan.jce.spec.ECPublicKeySpec)keySpec);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                return new JCEECPublicKey(this.algorithm, (ECPublicKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }
    }

    public static class GOST3410
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PrivateKeySpec) {
                return new JDKGOST3410PrivateKey((GOST3410PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof GOST3410PublicKeySpec) {
                return new JDKGOST3410PublicKey((GOST3410PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }

    public static class RSA
    extends JDKKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return JDKKeyFactory.createPrivateKeyFromDERStream(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (Exception e) {
                    try {
                        return new JCERSAPrivateCrtKey(new RSAPrivateKeyStructure((ASN1Sequence)ASN1Object.fromByteArray(((PKCS8EncodedKeySpec)keySpec).getEncoded())));
                    }
                    catch (Exception ex) {
                        throw new InvalidKeySpecException(ex.toString());
                    }
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                return new JCERSAPrivateCrtKey((RSAPrivateCrtKeySpec)keySpec);
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                return new JCERSAPrivateKey((RSAPrivateKeySpec)keySpec);
            }
            throw new InvalidKeySpecException("Unknown KeySpec type: " + keySpec.getClass().getName());
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof RSAPublicKeySpec) {
                return new JCERSAPublicKey((RSAPublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }
    }
}

