/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.math.ec;

import java.math.BigInteger;
import kz.gov.pki.kalkan.math.ec.ECCurve;
import kz.gov.pki.kalkan.math.ec.ECPoint;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P2, BigInteger a, ECPoint Q2, BigInteger b) {
        ECCurve c = P2.getCurve();
        if (!c.equals(Q2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P2, a, Q2, b);
    }

    public static ECPoint shamirsTrick(ECPoint P2, BigInteger k, ECPoint Q2, BigInteger l) {
        if (!P2.getCurve().equals(Q2.getCurve())) {
            throw new IllegalArgumentException("P and Q must be on same curve");
        }
        return ECAlgorithms.implShamirsTrick(P2, k, Q2, l);
    }

    private static ECPoint implShamirsTrick(ECPoint P2, BigInteger k, ECPoint Q2, BigInteger l) {
        int m = Math.max(k.bitLength(), l.bitLength());
        ECPoint Z = P2.add(Q2);
        ECPoint R = P2.getCurve().getInfinity();
        for (int i = m - 1; i >= 0; --i) {
            R = R.twice();
            if (k.testBit(i)) {
                if (l.testBit(i)) {
                    R = R.add(Z);
                    continue;
                }
                R = R.add(P2);
                continue;
            }
            if (!l.testBit(i)) continue;
            R = R.add(Q2);
        }
        return R;
    }
}

