/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.generators;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.pcsc.TokenDispatcher;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.encoders.Hex;

public class AKSecureRandom
extends SecureRandomSpi {
    private AKToken token;
    byte[] tokenId;

    protected void engineSetSeed(byte[] seed) {
        try {
            String tname = new String(seed);
            this.token = TokenDispatcher.INSTANCE.getToken(tname);
            this.tokenId = Hex.decode(this.token.getTokenId());
        }
        catch (KalkanException e) {
            e.printStackTrace();
        }
    }

    protected void engineNextBytes(byte[] bytes) {
        if (this.tokenId == null) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(bytes);
            return;
        }
        bytes = this.getRandom(bytes);
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] ret = new byte[numBytes];
        ret = this.getRandom(ret);
        return ret;
    }

    private byte[] getRandom(byte[] bytes) {
        int numBytes = bytes.length;
        byte[] random = this.token.getRandom(numBytes);
        SecureRandom sr = new SecureRandom();
        if (random == null) {
            random = new byte[numBytes];
            sr.nextBytes(random);
        }
        System.arraycopy(random, 0, bytes, 0, random.length);
        if (random.length != numBytes) {
            byte[] addRandom = new byte[numBytes - random.length];
            sr.nextBytes(addRandom);
            System.arraycopy(addRandom, 0, bytes, random.length, addRandom.length);
        }
        return bytes;
    }
}

