/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AKToken {
    public static final String GOST = "GOST";
    public static final String GOST512 = "GOST512";
    public static final String RSA = "RSA";
    static final int MAX_GZCERT_SIZE = 2048;
    public static final String RETRY_COUNT = "RetryCount";
    public static final String SW = "SW";
    protected ResponseAPDU respApdu;
    protected CommandAPDU capdu;
    protected Card sc;
    protected CardChannel ch;
    protected String tokenId;
    protected String tName;
    protected String pin;
    protected Map<String, String> infoMap = new HashMap<String, String>();

    public AKToken(String tName, String pin) throws KalkanException {
        this.tName = tName;
        this.pin = pin;
    }

    protected void connect() throws KalkanException {
        TerminalFactory factory = TerminalFactory.getDefault();
        CardTerminal terminal = factory.terminals().getTerminal(this.tName);
        try {
            if (terminal == null) {
                throw new CardException(this.tName + " not found!");
            }
            if (!terminal.isCardPresent()) {
                throw new CardException("Card not found!");
            }
            try {
                this.sc = terminal.connect("T=0");
            }
            catch (CardException ce) {
                this.sc = terminal.connect("T=1");
            }
            this.ch = this.sc.getBasicChannel();
        }
        catch (CardException ex) {
            throw new KalkanException(ex, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public abstract void disconnect();

    protected abstract void verifyPin(String var1) throws KalkanException;

    public abstract byte[] getPublicKey(String var1, byte var2) throws KalkanException;

    public abstract byte[] sign(String var1, byte[] var2, byte var3) throws KalkanException;

    public abstract byte generateKeyPair(String var1, String var2, boolean var3, int var4) throws KalkanException;

    public abstract void setCertificate(String var1, byte[] var2) throws KalkanException;

    public abstract byte[] getCertificate(String var1) throws KalkanException;

    public abstract Map<String, Byte> getAliases() throws KalkanException;

    public abstract PrivateKey getKey(String var1) throws KalkanException;

    public abstract byte[] getRandom(int var1);

    public abstract void deleteEntry(String var1) throws KalkanException;

    public abstract void changePin(byte var1, String var2) throws KalkanException;

    public String getPublicPartInfo(String field) {
        return this.infoMap.get(field);
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getTName() {
        return this.tName;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    protected void writeBinary(byte[] data, short offset, short size) throws CardException, KalkanException {
        ByteBuffer bb = ByteBuffer.allocate(2);
        int indx = 0;
        while (indx <= size - 1) {
            byte[] writeFile = null;
            bb.clear();
            bb.putShort(offset);
            byte hioffset = bb.get(0);
            byte looffset = bb.get(1);
            if (offset + 255 <= size) {
                writeFile = new byte[260];
                writeFile[4] = -1;
                System.arraycopy(data, indx, writeFile, 5, 255);
                indx = (short)(indx + 255);
                offset = (short)(offset + 255);
            } else {
                writeFile = new byte[size - indx + 5];
                writeFile[4] = (byte)(size - indx);
                System.arraycopy(data, indx, writeFile, 5, size - indx);
                indx = size;
            }
            writeFile[0] = 0;
            writeFile[1] = -42;
            writeFile[2] = hioffset;
            writeFile[3] = looffset;
            this.capdu = new CommandAPDU(writeFile);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) continue;
            throw new KalkanException(PCSCCode.WRITE_BINARY).set(SW, this.respApdu.getSW());
        }
    }

    protected byte[] readBinary(short offset, short size) throws CardException, KalkanException {
        byte[] ret = new byte[size];
        ByteBuffer bb = ByteBuffer.allocate(2);
        short indx = 0;
        byte[] readFile = new byte[]{0, -80, 0, 0, 0};
        while (indx < size) {
            bb.clear();
            bb.putShort(offset);
            readFile[2] = bb.get(0);
            readFile[3] = bb.get(1);
            if (indx + 255 <= size) {
                readFile[4] = -1;
                offset = (short)(offset + 255);
            } else {
                readFile[4] = (byte)(size - indx);
            }
            this.respApdu = this.ch.transmit(new CommandAPDU(readFile));
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.READ_BINARY).set(SW, this.respApdu.getSW());
            }
            byte[] data = this.respApdu.getData();
            if (data == null) continue;
            int len = data.length;
            System.arraycopy(data, 0, ret, indx, len);
            indx = (short)(indx + len);
        }
        return ret;
    }
}

