/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import kz.gov.pki.kalkan.exception.ErrorCode;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.PCSCCode;
import kz.gov.pki.kalkan.pcsc.AKGOST3410_2015PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKGOST34310PrivateKey;
import kz.gov.pki.kalkan.pcsc.AKRSAPrivateKey;
import kz.gov.pki.kalkan.pcsc.tokens.AKToken;
import kz.gov.pki.kalkan.util.ByteUtils;
import kz.gov.pki.kalkan.util.encoders.Hex;

public final class EToken5110
extends AKToken {
    private static final byte[] aid = new byte[]{-96, 0, 103, 97, 109, 109, 97, 116, 101, 99, 104, 103, 0};
    private Map<String, Byte> aliases = null;
    private Map<Byte, String> revAliases = null;

    public EToken5110(String tName, String pin) throws KalkanException {
        super(tName, pin);
        this.connect();
        try {
            this.capdu = new CommandAPDU(0, 164, 4, 0, aid);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.NOT_ETOKEN5110);
            }
            this.capdu = new CommandAPDU(128, 21, 32, 0);
            this.respApdu = this.ch.transmit(this.capdu);
            this.capdu = new CommandAPDU(128, 21, 33, 0, 100);
            this.respApdu = this.ch.transmit(this.capdu);
            byte[] tokensn = new byte[8];
            System.arraycopy(this.respApdu.getData(), 9, tokensn, 0, tokensn.length);
            this.tokenId = Hex.encodeStr(tokensn);
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        this.aliases = new LinkedHashMap<String, Byte>();
        this.revAliases = new LinkedHashMap<Byte, String>();
        this.getAliases();
        if (pin != null) {
            this.verifyPin(pin);
        }
    }

    public void disconnect() {
        try {
            if (this.sc != null) {
                this.sc.disconnect(false);
            }
        }
        catch (CardException e) {
            this.debugOut(e.getMessage());
        }
    }

    protected void verifyPin(String pin) throws KalkanException {
        if (pin == null || pin.isEmpty()) {
            throw new KalkanException(PCSCCode.INVALID_PIN_VALUE);
        }
        try {
            this.capdu = new CommandAPDU(128, 16, 33, 0, pin.getBytes());
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.WRONG_PIN).set("SW", this.respApdu.getSW());
            }
            this.debugOut("verification... ok!");
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    private byte[] getPublicKeyRSA(byte[] objName) throws CardException, KalkanException {
        this.debugOut("Get RAW RSA public key");
        byte[] pubKey = new byte[256];
        byte[] forKE = new byte[objName.length + 9];
        forKE[0] = -128;
        forKE[1] = 18;
        forKE[2] = 37;
        forKE[6] = (byte)objName.length;
        System.arraycopy(objName, 0, forKE, 7, objName.length);
        this.capdu = new CommandAPDU(forKE);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        System.arraycopy(this.respApdu.getData(), 3, pubKey, 0, 256);
        return pubKey;
    }

    private byte[] getPublicKeyGOST(byte[] objName) throws CardException, KalkanException {
        this.debugOut("Get RAW GOST public key");
        this.capdu = new CommandAPDU(128, 17, 33, 0, objName, 255);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_PUBKEY).set("SW", this.respApdu.getSW());
        }
        byte[] pubKey = this.respApdu.getData();
        byte[] part = new byte[pubKey.length / 2];
        System.arraycopy(pubKey, 0, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, pubKey, 0, part.length);
        System.arraycopy(pubKey, part.length, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, pubKey, part.length, part.length);
        return pubKey;
    }

    public byte[] getPublicKey(String algName, byte keyId) throws KalkanException {
        byte[] ret = null;
        byte[] objName = EToken5110.getAliasAsByteArray(this.revAliases.get(keyId));
        try {
            if (algName.equals("GOST") || algName.equals("GOST512")) {
                ret = this.getPublicKeyGOST(objName);
            } else if (algName.equals("RSA")) {
                ret = this.getPublicKeyRSA(objName);
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private byte[] signGOST(byte[] data, byte[] objName) throws CardException, KalkanException {
        this.debugOut("GOST signing");
        byte[] forSign = new byte[objName.length + data.length];
        System.arraycopy(objName, 0, forSign, 0, objName.length);
        data = ByteUtils.inverseCopyByte(data, 0, data.length);
        System.arraycopy(data, 0, forSign, objName.length, data.length);
        this.capdu = new CommandAPDU(128, 20, 32, 0, forSign, 255);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        byte[] sign = this.respApdu.getData();
        byte[] part = new byte[sign.length / 2];
        System.arraycopy(sign, 0, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, sign, 0, part.length);
        System.arraycopy(sign, part.length, part, 0, part.length);
        part = ByteUtils.inverseCopyByte(part, 0, part.length);
        System.arraycopy(part, 0, sign, part.length, part.length);
        return sign;
    }

    private byte[] signRSA(byte[] data, byte[] objName) throws CardException, KalkanException {
        this.debugOut("RSA signing");
        byte[] hash = data;
        byte[] forSign = new byte[256];
        forSign[0] = 0;
        forSign[1] = 1;
        for (int i = 2; i < forSign.length - hash.length - 1; ++i) {
            forSign[i] = -1;
        }
        System.arraycopy(hash, 0, forSign, forSign.length - hash.length, hash.length);
        byte[] objNameSgn = new byte[objName.length + 2 + forSign.length];
        objNameSgn[objName.length] = 1;
        System.arraycopy(objName, 0, objNameSgn, 0, objName.length);
        System.arraycopy(forSign, 0, objNameSgn, objName.length + 2, forSign.length);
        this.capdu = new CommandAPDU(128, 20, 35, 36, objNameSgn, 258);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.SIGN_FAILURE).set("SW", this.respApdu.getSW());
        }
        byte[] sign = this.respApdu.getData();
        return sign;
    }

    public byte[] sign(String algName, byte[] data, byte keyId) throws KalkanException {
        byte[] ret = null;
        byte[] objName = EToken5110.getAliasAsByteArray(this.revAliases.get(keyId));
        try {
            if (algName.equals("GOST") || algName.equals("GOST512")) {
                ret = this.signGOST(data, objName);
            } else if (algName.equals("RSA")) {
                ret = this.signRSA(data, objName);
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    private void genKeyPairRSA(byte[] objName) throws KalkanException, CardException {
        this.debugOut("RSA key pair generation");
        byte[] forKG = new byte[objName.length + 5];
        forKG[1] = (byte)(objName.length + 3);
        forKG[2] = 8;
        forKG[4] = 8;
        System.arraycopy(objName, 0, forKG, 5, objName.length);
        this.capdu = new CommandAPDU(128, 17, 35, 0, forKG);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
        }
    }

    private void genKeyPairGOST(byte[] objName, String algName) throws KalkanException, CardException {
        this.debugOut(algName + " key pair generation");
        byte[] forKG = new byte[objName.length + 1];
        forKG[0] = "GOST".equals(algName) ? 1 : 12;
        System.arraycopy(objName, 0, forKG, 1, objName.length);
        this.capdu = new CommandAPDU(128, 17, 32, 0, forKG);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.GENKEYPAIR_FAILURE).set("SW", this.respApdu.getSW());
        }
    }

    public byte generateKeyPair(String algName, String alias, boolean isXch, int keyLength) throws KalkanException {
        block5: {
            this.verifyPin(this.pin);
            if (this.getAliases().containsKey(alias)) {
                throw new KalkanException(alias + " already exists!", (ErrorCode)PCSCCode.GENKEYPAIR_FAILURE);
            }
            byte[] objName = EToken5110.getAliasAsByteArray(alias);
            try {
                if (algName.equals("GOST") || algName.equals("GOST512")) {
                    this.genKeyPairGOST(objName, algName);
                    break block5;
                }
                if (algName.equals("RSA")) {
                    this.genKeyPairRSA(objName);
                    break block5;
                }
                throw new KalkanException(PCSCCode.UNKNOWN_ALGORITHM);
            }
            catch (CardException ce) {
                throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
            }
        }
        return (Byte)this.getAliases().get(alias);
    }

    public void setCertificate(String alias, byte[] certificate) throws KalkanException {
        byte[] objName = EToken5110.getAliasAsByteArray(alias);
        try {
            ByteArrayOutputStream gzbaos = new ByteArrayOutputStream();
            GZIPOutputStream gzout = new GZIPOutputStream(gzbaos);
            gzout.write(certificate);
            gzout.close();
            gzbaos.close();
            this.debugOut("Certificate has been GZipped");
            byte[] gzcer = gzbaos.toByteArray();
            if (gzcer.length > 2048) {
                throw new KalkanException(PCSCCode.LARGE_GZCERT).set("MaxGZCertSize", 2048).set("CertSize", certificate.length).set("GZCertSize", gzcer.length);
            }
            short certSize = (short)gzcer.length;
            this.debugOut("was: " + certificate.length + "; now: " + certSize);
            byte[] forCert = new byte[2 + objName.length + gzcer.length];
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(certSize);
            bb.clear();
            bb.get(forCert, 0, 2);
            System.arraycopy(objName, 0, forCert, 2, objName.length);
            System.arraycopy(gzcer, 0, forCert, objName.length + 2, gzcer.length);
            this.capdu = new CommandAPDU(128, 18, 39, 0, forCert);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.SETCERT_FAILURE).set("SW", this.respApdu.getSW());
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        catch (IOException ioe) {
            throw new KalkanException(ioe, (ErrorCode)PCSCCode.IOEXCEPTION);
        }
    }

    public byte[] getCertificate(String alias) throws KalkanException {
        byte[] ret = null;
        try {
            this.capdu = new CommandAPDU(128, 18, 40, 0, EToken5110.getAliasAsByteArray(alias), 4096);
            this.respApdu = this.ch.transmit(this.capdu);
            byte[] gzcert = this.respApdu.getBytes();
            ByteArrayOutputStream ungzbaos = new ByteArrayOutputStream();
            ByteArrayInputStream gzbais = new ByteArrayInputStream(gzcert);
            try {
                this.debugOut("UnGZipping certificate");
                GZIPInputStream gzin = new GZIPInputStream(gzbais);
                int c = gzin.read();
                while (c != -1) {
                    ungzbaos.write(c);
                    c = gzin.read();
                }
                gzin.close();
                gzbais.close();
                ungzbaos.close();
                ret = ungzbaos.toByteArray();
                this.debugOut("cert: " + ret.length);
            }
            catch (IOException ioe) {
                ret = gzcert;
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return ret;
    }

    public Map getAliases() throws KalkanException {
        try {
            this.capdu = new CommandAPDU(128, 18, 34, 0, 256);
            this.respApdu = this.ch.transmit(this.capdu);
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(this.respApdu.getData());
            short c = bb.getShort(0);
            for (short i = 0; i < c; i = (short)(i + 1)) {
                bb.clear();
                bb.putShort(0, i);
                byte[] b = new byte[2];
                bb.get(b);
                this.capdu = new CommandAPDU(128, 18, 33, 0, b, 50);
                this.respApdu = this.ch.transmit(this.capdu);
                byte[] objNameRaw = this.respApdu.getData();
                int nullPos = ByteUtils.indexOf(this.respApdu.getData(), new byte[]{0}, 0);
                if (nullPos != -1) {
                    byte[] objName = new byte[nullPos + 2];
                    objName[0] = 0;
                    objName[1] = (byte)nullPos;
                    System.arraycopy(objNameRaw, 0, objName, 2, nullPos);
                    this.aliases.put(Hex.encodeStr(objNameRaw).substring(0, nullPos * 2), (byte)i);
                    this.revAliases.put((byte)i, Hex.encodeStr(objNameRaw).substring(0, nullPos * 2));
                    continue;
                }
                this.aliases.put(Hex.encodeStr(objNameRaw), (byte)i);
                this.revAliases.put((byte)i, Hex.encodeStr(objNameRaw));
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        return this.aliases;
    }

    public PrivateKey getKey(String alias) throws KalkanException {
        this.verifyPin(this.pin);
        try {
            byte[] objName = EToken5110.getAliasAsByteArray(alias);
            byte[] objNameChk = new byte[objName.length + 2];
            System.arraycopy(objName, 0, objNameChk, 0, objName.length);
            this.capdu = new CommandAPDU(128, 18, 36, 0, objNameChk);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                byte keyIdentifier = this.obtainKeyIdentifier(objNameChk)[0];
                switch (keyIdentifier) {
                    case 1: {
                        return new AKGOST34310PrivateKey(this, this.aliases.get(alias));
                    }
                    case 12: {
                        return new AKGOST3410_2015PrivateKey(this, this.aliases.get(alias));
                    }
                }
                throw new KalkanException(PCSCCode.INVALID_PRIVKEY);
            }
            objNameChk[objNameChk.length - 1] = 3;
            this.capdu = new CommandAPDU(128, 18, 36, 0, objNameChk);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() == 36864) {
                return new AKRSAPrivateKey(this, this.aliases.get(alias));
            }
            throw new KalkanException(PCSCCode.INVALID_PRIVKEY).set("SW", this.respApdu.getSW());
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public byte[] getRandom(int lc) {
        return null;
    }

    private void debugOut(String s) {
        System.out.println("[EToken5110]> " + s);
    }

    public void deleteEntry(String alias) throws KalkanException {
        this.debugOut("Deleting " + alias);
        try {
            byte[] objName = EToken5110.getAliasAsByteArray(alias);
            this.capdu = new CommandAPDU(128, 18, 35, 0, objName);
            this.respApdu = this.ch.transmit(this.capdu);
            if (this.respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.DELETE_FAILURE).set("SW", this.respApdu.getSW());
            }
        }
        catch (CardException ce) {
            throw new KalkanException(ce, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
    }

    public void formatAndResetPwd() throws KalkanException {
        this.debugOut("format eToken5110");
        try {
            byte[] cmd = new byte[]{-128, 18, 38, 0, 0};
            ResponseAPDU respApdu = this.ch.transmit(new CommandAPDU(cmd));
            if (respApdu.getSW() != 36864) {
                throw new KalkanException(PCSCCode.DELETE_FAILURE).set("SW", respApdu.getSW());
            }
        }
        catch (CardException ce) {
            throw new KalkanException(PCSCCode.CARD_EXCEPTION);
        }
    }

    private byte[] obtainKeyIdentifier(byte[] objName) throws CardException, KalkanException {
        this.capdu = new CommandAPDU(128, 17, 34, 0, objName, 1);
        this.respApdu = this.ch.transmit(this.capdu);
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.INVALID_DATA).set("SW", this.respApdu.getSW());
        }
        return this.respApdu.getData();
    }

    private static byte[] getAliasAsByteArray(String alias) {
        byte[] b = Hex.decode(alias);
        byte[] ret = new byte[b.length + 2];
        ret[0] = 0;
        ret[1] = (byte)b.length;
        System.arraycopy(b, 0, ret, 2, b.length);
        return ret;
    }

    public void changePin(byte type, String pin) throws KalkanException {
        int pinl = pin.getBytes().length;
        if (pinl > 10) {
            throw new KalkanException(PCSCCode.INVALID_PIN_VALUE).set("MaxLength", 10);
        }
        byte[] data = new byte[2 + this.pin.length() + pin.length()];
        System.arraycopy(this.pin.getBytes(), 0, data, 2, this.pin.length());
        System.arraycopy(pin.getBytes(), 0, data, 2 + this.pin.length(), pinl);
        data[0] = (byte)this.pin.length();
        data[1] = (byte)pin.length();
        this.capdu = new CommandAPDU(128, 16, 32, 0, data);
        try {
            this.respApdu = this.ch.transmit(this.capdu);
        }
        catch (CardException e) {
            throw new KalkanException(e, (ErrorCode)PCSCCode.CARD_EXCEPTION);
        }
        if (this.respApdu.getSW() != 36864) {
            throw new KalkanException(PCSCCode.CHANGEPIN_FAILURE).set("SW", this.respApdu.getSW());
        }
    }
}

