/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.ess.ESSCertIDv2;
import kz.gov.pki.kalkan.asn1.ess.SigningCertificateV2;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformationStore;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.TSPUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.provider.utils.verifier.Verifier;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.provider.utils.verifier.VerifyCMSSignatureResult;
import kz.gov.pki.provider.utils.verifier.VerifyX509CertifcateResult;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;

public class CMSUtil {
    public static CMSSignedData parseAsCMS(byte[] data) throws CMSException {
        try {
            return new CMSSignedData(data);
        }
        catch (IllegalStateException e) {
            throw new CMSException(e.getMessage(), e);
        }
    }

    public static CMSSignedData createCAdES(Storage storage, KeyStore keyStore, String alias, char[] password, byte[] data, boolean encapsulate, KalkanHashAlgorithm hashAlg, TSAPolicy policy, KNCAServiceRequestMethod method, Provider provider) throws KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateEncodingException, InvalidAlgorithmParameterException, CertStoreException, CertificateNotYetValidException, ProviderUtilException, TSPException, CertificateExpiredException, NoSuchProviderException, CMSException {
        return CMSUtil.createCAdES(keyStore, alias, password, data, encapsulate, hashAlg, policy, method, provider);
    }

    public static CMSSignedData createCAdES(KeyStore keyStore, String alias, char[] password, byte[] data, boolean encapsulate, KalkanHashAlgorithm hashAlg, TSAPolicy policy, KNCAServiceRequestMethod method, Provider provider) throws KeyStoreException, IOException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateEncodingException, InvalidAlgorithmParameterException, CertStoreException, CertificateNotYetValidException, ProviderUtilException, TSPException, CertificateExpiredException, NoSuchProviderException, CMSException {
        TSAProfile tsaProfile = new TSAProfile();
        tsaProfile.setHashAlgorithm(hashAlg);
        tsaProfile.setRequestMethod(method);
        tsaProfile.setTsaPolicy(policy);
        SigningEntity signingEntity = KeyStoreUtil.getSigningEntity(keyStore, alias, password);
        CMSSignedData signedData = CMSUtil.createCAdES(signingEntity, data, encapsulate, false, provider);
        if (hashAlg != null && method != null && policy != null) {
            signedData = CMSUtil.applyCAdEST(signedData, signingEntity, tsaProfile, provider);
        }
        return signedData;
    }

    public static CMSSignedData createCAdES(SigningEntity signingEntity, byte[] data, boolean encapsulate, boolean isDigested, Provider provider) throws ProviderUtilException {
        try {
            CMSProcessableByteArray content;
            String digestOid;
            PrivateKey privateKey = signingEntity.getKey();
            X509Certificate x509Certificate = signingEntity.getCertificateChain().get(0);
            ArrayList<X509Certificate> selfChain = new ArrayList<X509Certificate>();
            selfChain.add(x509Certificate);
            CertStore chainStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(selfChain), provider);
            if (isDigested) {
                digestOid = "1.2.398.3.10.1.3";
            } else if (x509Certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
                digestOid = CMSSignedDataGenerator.DIGEST_SHA1;
            } else if (x509Certificate.getSigAlgOID().equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
                digestOid = CMSSignedDataGenerator.DIGEST_SHA256;
            } else if (x509Certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId())) {
                digestOid = CMSSignedDataGenerator.DIGEST_GOST34311_95;
            } else if (x509Certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId())) {
                digestOid = CMSSignedDataGenerator.DIGEST_GOST3411_2015_512;
            } else if (x509Certificate.getSigAlgOID().equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004.getId())) {
                digestOid = CMSSignedDataGenerator.DIGEST_GOST3411_GT;
            } else {
                throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_ALGORITHM);
            }
            Hashtable<DERObjectIdentifier, Attribute> ht = new Hashtable<DERObjectIdentifier, Attribute>();
            ESSCertIDv2 essCertIDv2 = new ESSCertIDv2(null, MessageDigest.getInstance("SHA-256", provider).digest(x509Certificate.getEncoded()));
            SigningCertificateV2 signingCertificateV2 = new SigningCertificateV2(new ESSCertIDv2[]{essCertIDv2});
            Attribute sigCertAttr = new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificateV2, new DERSet(signingCertificateV2));
            ht.put(sigCertAttr.getAttrType(), sigCertAttr);
            AttributeTable sAttrTable = new AttributeTable(ht);
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSigner(privateKey, x509Certificate, digestOid, sAttrTable, null);
            generator.addCertificatesAndCRLs(chainStore);
            try {
                CMSSignedData cms = CMSUtil.parseAsCMS(data);
                CMSProcessable processable = cms.getSignedContent();
                if (processable == null) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_NO_ENCAPSULATED_DATA);
                }
                content = new CMSProcessableByteArray((byte[])processable.getContent());
                generator.addSigners(cms.getSignerInfos());
                generator.addCertificatesAndCRLs(cms.getCertificatesAndCRLs("Collection", provider.getName()));
            }
            catch (CMSException e) {
                content = new CMSProcessableByteArray(data);
            }
            CMSSignedData signedData = generator.generate(content, encapsulate, provider.getName());
            return signedData;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CertificateEncodingException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.PROVIDER_INVOCATION_FAILURE, (Throwable)e);
        }
        catch (CMSException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_PROCESSING_FAILURE, (Throwable)e);
        }
    }

    public static CMSSignedData createCAdES(SigningEntity signingEntity, byte[] data, boolean encapsulate, Provider provider) throws ProviderUtilException {
        return CMSUtil.createCAdES(signingEntity, data, encapsulate, false, provider);
    }

    public static CMSSignedData createCAdES(SigningEntity signingEntity, byte[] data, Provider provider) throws ProviderUtilException {
        return CMSUtil.createCAdES(signingEntity, data, false, true, provider);
    }

    public static CMSSignedData applyCAdEST(CMSSignedData signedData, SigningEntity signingEntity, TSAProfile tsaProfile, Provider provider) throws ProviderUtilException {
        SignerId selector = new SignerId();
        X509Certificate x509Certificate = signingEntity.getCertificateChain().get(0);
        selector.setSerialNumber(x509Certificate.getSerialNumber());
        selector.setIssuer(x509Certificate.getIssuerX500Principal());
        SignerInformation signerInfo = signedData.getSignerInfos().get(selector);
        Collection signerInfos = signedData.getSignerInfos().getSigners();
        signerInfos.remove(signerInfo);
        signerInfos.add(CMSUtil.addTimestampToken(signerInfo, tsaProfile, provider));
        SignerInformationStore signerInformationStore = new SignerInformationStore(signerInfos);
        return CMSSignedData.replaceSigners(signedData, signerInformationStore);
    }

    private static SignerInformation addTimestampToken(SignerInformation signerInfo, TSAProfile tsaProfile, Provider provider) throws ProviderUtilException {
        try {
            byte[] signature = signerInfo.getSignature();
            TimeStampResponse response = TSPUtil.getTimeStampResponse(signature, tsaProfile, provider);
            Hashtable<DERObjectIdentifier, Attribute> uht = new Hashtable<DERObjectIdentifier, Attribute>();
            ASN1InputStream asn1InputStream = new ASN1InputStream(response.getTimeStampToken().getEncoded());
            Attribute tstAttr = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, new DERSet(asn1InputStream.readObject()));
            uht.put(tstAttr.getAttrType(), tstAttr);
            asn1InputStream.close();
            AttributeTable uAttrTable = new AttributeTable(uht);
            return SignerInformation.replaceUnsignedAttributes(signerInfo, uAttrTable);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CertificateExpiredException | CertificateNotYetValidException | CMSException | TSPException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.TIMESTAMP_CREATION_FAILURE, (Throwable)e);
        }
    }

    public static List<SignerInformation> getSignerInformations(CMSSignedData cms) {
        List<SignerInformation> signerList = Collections.unmodifiableList(new ArrayList(cms.getSignerInfos().getSigners()));
        return signerList;
    }

    public static List<X509Certificate> getX509Certificates(CMSSignedData cms, Provider provider) throws CMSException, NoSuchAlgorithmException, NoSuchProviderException, CertStoreException {
        return CMSUtil.getX509Certificates(cms, provider);
    }

    public static List<X509Certificate> getSignerCertificates(CMSSignedData cms, Provider provider) throws ProviderUtilException {
        try {
            List<SignerInformation> signerList = CMSUtil.getSignerInformations(cms);
            CertStore certs = cms.getCertificatesAndCRLs("Collection", provider.getName());
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            for (SignerInformation signer : signerList) {
                SignerId signerConstraints = signer.getSID();
                Collection<? extends Certificate> certificates = certs.getCertificates(signerConstraints);
                certList.add((X509Certificate)certificates.iterator().next());
            }
            return Collections.unmodifiableList(certList);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertStoreException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.PROVIDER_INVOCATION_FAILURE, (Throwable)e);
        }
        catch (CMSException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_PROCESSING_FAILURE, (Throwable)e);
        }
    }

    public static void verifyCMS(byte[] cmsData, byte[] srcData, Provider provider) throws ProviderUtilException {
        try {
            boolean isExternal;
            CMSSignedData cms = CMSUtil.parseAsCMS(cmsData);
            boolean bl = isExternal = cms.getSignedContent() == null;
            if (isExternal) {
                if (srcData == null) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_NO_ENCAPSULATED_DATA);
                }
                CMSProcessableByteArray data = new CMSProcessableByteArray(srcData);
                cms = new CMSSignedData((CMSProcessable)data, cmsData);
            }
            SignerInformationStore signers = cms.getSignerInfos();
            CertStore certs = cms.getCertificatesAndCRLs("Collection", provider.getName());
            Iterator it = signers.getSigners().iterator();
            if (!it.hasNext()) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND, "Signers not found!");
            }
            while (it.hasNext()) {
                SigningCertificateV2 sigCertV2;
                ESSCertIDv2 essCertIDv2;
                byte[] certHash;
                X509Certificate cert;
                SignerInformation signer;
                block11: {
                    signer = (SignerInformation)it.next();
                    SignerId signerConstraints = signer.getSID();
                    Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
                    Iterator<? extends Certificate> certIt = certCollection.iterator();
                    cert = null;
                    if (certIt.hasNext()) {
                        cert = (X509Certificate)certIt.next();
                        try {
                            if (!signer.verify(cert, provider.getName())) {
                                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_SIGNATURE_NOT_VALID);
                            }
                            break block11;
                        }
                        catch (CertificateExpiredException | CertificateNotYetValidException e) {
                            throw new ProviderUtilException(ProviderUtilExceptionCode.CERTIFICATE_DATE_NOT_VALID, (Throwable)e);
                        }
                    }
                    throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
                }
                AttributeTable sat = signer.getSignedAttributes();
                Attribute sigCertV2Attr = sat.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (sigCertV2Attr == null || Arrays.equals(certHash = MessageDigest.getInstance((essCertIDv2 = (sigCertV2 = SigningCertificateV2.getInstance(sigCertV2Attr.getAttrValues().getObjectAt(0))).getCerts()[0]).getHashAlgorithm().getObjectId().getId(), provider).digest(cert.getEncoded()), essCertIDv2.getCertHash())) continue;
                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_ESSCERTIDV2_DIFF_CERTHASH);
            }
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | CertStoreException | CertificateEncodingException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.PROVIDER_INVOCATION_FAILURE, (Throwable)e);
        }
        catch (CMSException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_PROCESSING_FAILURE, (Throwable)e);
        }
    }

    public static void verifyCMS(byte[] cmsData, Provider provider) throws ProviderUtilException {
        CMSUtil.verifyCMS(cmsData, null, provider);
    }

    public static Set<VerifyCMSSignatureResult> verifyCMS(byte[] cmsData, byte[] srcData, VerifierFlags verifyerFlags, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, Provider provider) throws CMSException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException, CertificateNotYetValidException, CertificateExpiredException, ProviderUtilException, CertificateEncodingException, IOException, TSPException, CertificateException, CertificateParsingException, InvalidAlgorithmParameterException, CertPathBuilderException {
        boolean isExternal;
        CMSSignedData cms = CMSUtil.parseAsCMS(cmsData);
        boolean bl = isExternal = cms.getSignedContent() == null;
        if (isExternal) {
            if (srcData == null) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_NO_ENCAPSULATED_DATA);
            }
            CMSProcessableByteArray data = new CMSProcessableByteArray(srcData);
            cms = new CMSSignedData((CMSProcessable)data, cmsData);
        }
        SignerInformationStore signers = cms.getSignerInfos();
        CertStore certs = cms.getCertificatesAndCRLs("Collection", provider.getName());
        Iterator it = signers.getSigners().iterator();
        HashSet<VerifyCMSSignatureResult> resultSet = new HashSet<VerifyCMSSignatureResult>();
        while (it.hasNext()) {
            SigningCertificateV2 sigCertV2;
            ESSCertIDv2 essCertIDv2;
            byte[] certHash;
            SignerInformation signer = (SignerInformation)it.next();
            SignerId signerConstraints = signer.getSID();
            Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = null;
            boolean ret = false;
            VerifyX509CertifcateResult vCertResult = null;
            if (certIt.hasNext()) {
                cert = (X509Certificate)certIt.next();
                if (verifyerFlags != null) {
                    vCertResult = Verifier.verifyX509Certificate(cert, caCertList, crlList, verifyerFlags);
                }
                if (signer.verify(cert, provider.getName())) {
                    ret = true;
                }
            } else {
                throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
            }
            VerifyCMSSignatureResult result = new VerifyCMSSignatureResult(vCertResult, ret);
            AttributeTable sat = signer.getSignedAttributes();
            Attribute sigCertV2Attr = sat.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            if (sigCertV2Attr != null && !Arrays.equals(certHash = MessageDigest.getInstance((essCertIDv2 = (sigCertV2 = SigningCertificateV2.getInstance(sigCertV2Attr.getAttrValues().getObjectAt(0))).getCerts()[0]).getHashAlgorithm().getObjectId().getId(), provider).digest(cert.getEncoded()), essCertIDv2.getCertHash())) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_ESSCERTIDV2_DIFF_CERTHASH);
            }
            TimeStampToken tsToken = CMSUtil.getTimestampToken(signer, provider);
            if (tsToken != null) {
                TSPUtil.validateTimeStampToken(tsToken, signer.getSignature(), provider);
                result.setTsToken(tsToken);
            }
            resultSet.add(result);
        }
        return resultSet;
    }

    public static TimeStampToken getTimestampToken(SignerInformation signer, Provider provider) throws ProviderUtilException {
        try {
            Attribute tstAttr;
            TimeStampToken tsToken = null;
            AttributeTable uat = signer.getUnsignedAttributes();
            if (uat != null && (tstAttr = uat.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                CMSSignedData tokenCms = new CMSSignedData(tstAttr.getAttrValues().getObjectAt(0).getDERObject().getEncoded());
                tsToken = new TimeStampToken(tokenCms);
            }
            return tsToken;
        }
        catch (IOException | CMSException | TSPException e) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.TIMESTAMP_PARSING_FAILURE);
        }
    }

    @Deprecated
    public static Set<VerifyCMSSignatureResult> verifyCMS(byte[] cmsData, byte[] srcData, VerifierFlags verifyerFlags, Map<String, X509Certificate> mapCaCert, URL ocspUrl, Provider provider) throws CMSException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException, CertificateNotYetValidException, CertificateExpiredException, ProviderUtilException, CertificateEncodingException, IOException, TSPException, CertificateException, CertificateParsingException, OCSPException {
        boolean isExternal;
        CMSSignedData cms = CMSUtil.parseAsCMS(cmsData);
        boolean bl = isExternal = cms.getSignedContent() == null;
        if (isExternal) {
            if (srcData == null) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_NO_ENCAPSULATED_DATA);
            }
            CMSProcessableByteArray data = new CMSProcessableByteArray(srcData);
            cms = new CMSSignedData((CMSProcessable)data, cmsData);
        }
        SignerInformationStore signers = cms.getSignerInfos();
        CertStore certs = cms.getCertificatesAndCRLs("Collection", provider.getName());
        Iterator it = signers.getSigners().iterator();
        HashSet<VerifyCMSSignatureResult> resultSet = new HashSet<VerifyCMSSignatureResult>();
        while (it.hasNext()) {
            SigningCertificateV2 sigCertV2;
            ESSCertIDv2 essCertIDv2;
            byte[] certHash;
            SignerInformation signer = (SignerInformation)it.next();
            SignerId signerConstraints = signer.getSID();
            Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
            Iterator<? extends Certificate> certIt = certCollection.iterator();
            X509Certificate cert = null;
            boolean ret = false;
            VerifyX509CertifcateResult vCertResult = null;
            if (certIt.hasNext()) {
                cert = (X509Certificate)certIt.next();
                if (verifyerFlags != null) {
                    vCertResult = Verifier.verifyX509Certificate(cert, mapCaCert, provider, ocspUrl, verifyerFlags);
                }
                if (signer.verify(cert, provider.getName())) {
                    ret = true;
                }
            } else {
                throw new ProviderUtilException(ProviderUtilExceptionCode.SIGNER_CERTIFICATE_NOT_FOUND);
            }
            resultSet.add(new VerifyCMSSignatureResult(vCertResult, ret));
            AttributeTable sat = signer.getSignedAttributes();
            Attribute sigCertV2Attr = sat.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            if (sigCertV2Attr != null && !Arrays.equals(certHash = MessageDigest.getInstance((essCertIDv2 = (sigCertV2 = SigningCertificateV2.getInstance(sigCertV2Attr.getAttrValues().getObjectAt(0))).getCerts()[0]).getHashAlgorithm().getObjectId().getId(), provider).digest(cert.getEncoded()), essCertIDv2.getCertHash())) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_ESSCERTIDV2_DIFF_CERTHASH);
            }
            TimeStampToken tsToken = CMSUtil.getTimestampToken(signer, provider);
            TSPUtil.validateTimeStampToken(tsToken, signer.getSignature(), provider);
        }
        return resultSet;
    }
}

