/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.IOException;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.HashMap;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.pkcs.CertificationRequestInfo;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.jce.PKCS10CertificationRequest;
import kz.gov.pki.kalkan.openssl.PEMReader;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;

public class CSRUtil {
    public static PKCS10CertificationRequest getPKCS10CertificationRequest(String requestPem) throws IOException {
        try (PEMReader pemReader = new PEMReader(new StringReader(requestPem));){
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)pemReader.readObject();
            return pKCS10CertificationRequest;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getPem(PKCS10CertificationRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String genPKCS10CertificationRequest(String signatureAlgorithm, X509Name subjectDN, PublicKey publicKey, ASN1Set extensionSet, PrivateKey privateKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, ProviderUtilException, IOException {
        PKCS10CertificationRequest pkcscr = new PKCS10CertificationRequest(signatureAlgorithm, subjectDN, publicKey, extensionSet, privateKey);
        if (!pkcscr.verify()) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INVALID_PKCS10_SIGNATURE);
        }
        return CSRUtil.getPem(pkcscr);
    }

    /*
     * Exception decompiling
     */
    public static String getKeyId(PKCS10CertificationRequest pkcscr) throws ProviderUtilException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getSubjectAlternativeName(PKCS10CertificationRequest pkcscr) throws ProviderUtilException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getPublicKeyBytes(PKCS10CertificationRequest csr, Provider provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        PublicKey pk = csr.getPublicKey(provider.getName());
        ASN1Object pubKey = ASN1Object.fromByteArray(pk.getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(pubKey);
        return subjectPublicKeyInfo.getPublicKeyData().getBytes();
    }

    public static HashMap<String, String> getRDNMapFromPKCS10(String pem) throws IOException {
        PKCS10CertificationRequest csr = CSRUtil.getPKCS10CertificationRequest(pem);
        return CSRUtil.getRDNMapFromPKCS10CR(csr);
    }

    public static HashMap<String, String> getRDNMapFromPKCS10CR(PKCS10CertificationRequest csr) {
        HashMap<String, String> mapOidValue = new HashMap<String, String>();
        CertificationRequestInfo info = csr.getCertificationRequestInfo();
        for (Object s : info.getSubject().getOIDs()) {
            DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)s;
            String oid = objectIdentifier.getId();
            String value = (String)info.getSubject().getValues(objectIdentifier).firstElement();
            mapOidValue.put(oid, value);
        }
        return mapOidValue;
    }

    public static void checkForRepeatingRDN(PKCS10CertificationRequest csr) throws ProviderUtilException {
        CertificationRequestInfo info = csr.getCertificationRequestInfo();
        for (Object s : info.getSubject().getOIDs()) {
            DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)s;
            String oid = objectIdentifier.getId();
            if (info.getSubject().getValues(objectIdentifier).size() <= 1) continue;
            throw new ProviderUtilException(ProviderUtilExceptionCode.CSR_REPEATING_RDN, oid);
        }
    }

    public static String getAlgorithmId(String pem) throws IOException {
        return CSRUtil.getPKCS10CertificationRequest(pem).getSignatureAlgorithm().getObjectId().getId();
    }
}

