/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampRequest;
import kz.gov.pki.kalkan.tsp.TimeStampRequestGenerator;
import kz.gov.pki.kalkan.tsp.TimeStampResponse;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.kalkan.tsp.TimeStampTokenInfo;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;

public class TSPUtil {
    @Deprecated
    public static final String TSA_URL_PROP = "knca.tsaURL";
    @Deprecated
    public static final String TSA_URL = "http://tsp.pki.gov.kz/";
    private static final SecureRandom random = new SecureRandom();

    public static TimeStampResponse getTimeStampResponse(byte[] data, KalkanHashAlgorithm hashAlg, TSAPolicy policy, KNCAServiceRequestMethod method, Provider provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, TSPException, CMSException, CertStoreException, CertificateExpiredException, CertificateNotYetValidException, ProviderUtilException {
        TSAProfile tsaProfile = new TSAProfile();
        tsaProfile.setHashAlgorithm(hashAlg);
        tsaProfile.setRequestMethod(method);
        tsaProfile.setTsaPolicy(policy);
        return TSPUtil.getTimeStampResponse(data, tsaProfile, provider);
    }

    public static TimeStampResponse getTimeStampResponse(byte[] data, TSAProfile tsaProfile, Provider provider) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, TSPException, CMSException, CertStoreException, CertificateExpiredException, CertificateNotYetValidException, ProviderUtilException {
        TimeStampResponse response;
        URL newurl;
        HttpURLConnection con;
        String hashAlgId = tsaProfile.getHashAlgorithm().getId();
        MessageDigest md = MessageDigest.getInstance(hashAlgId, provider.getName());
        md.update(data);
        byte[] hash = md.digest();
        TimeStampRequestGenerator reqGen = new TimeStampRequestGenerator();
        reqGen.setCertReq(true);
        reqGen.setReqPolicy(tsaProfile.getTsaPolicy().getId());
        BigInteger nonce = BigInteger.valueOf(random.nextLong());
        TimeStampRequest request = reqGen.generate(hashAlgId, hash, nonce);
        byte[] reqData = request.getEncoded();
        String b64 = URLEncoder.encode(Base64.encodeStr(reqData), "UTF-8");
        String tsaUrl = tsaProfile.getTsaURL();
        if (tsaProfile.getRequestMethod().equals((Object)KNCAServiceRequestMethod.POST)) {
            con = (HttpURLConnection)new URL(tsaUrl).openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setRequestProperty("Content-Type", "application/timestamp-query");
            try (OutputStream reqStream = con.getOutputStream();){
                reqStream.write(reqData);
            }
        } else if (tsaUrl.endsWith("/")) {
            newurl = new URL(tsaUrl + b64);
            con = (HttpURLConnection)newurl.openConnection();
        } else {
            newurl = new URL(tsaUrl + "/" + b64);
            con = (HttpURLConnection)newurl.openConnection();
        }
        if (con.getResponseCode() != 200) {
            throw new TSPException("HTTP error code: " + con.getResponseCode());
        }
        if (!"application/timestamp-reply".equals(con.getContentType())) {
            throw new TSPException("Wrong content-type: " + con.getContentType());
        }
        try (InputStream respStream = con.getInputStream();){
            response = new TimeStampResponse(respStream);
        }
        response.validate(request);
        TimeStampToken token = response.getTimeStampToken();
        TSPUtil.validateTimeStampToken(token, data, provider);
        return response;
    }

    public static X509Certificate getTSPCertificate(TimeStampToken token, Provider provider) throws NoSuchAlgorithmException, CertStoreException, NoSuchProviderException, CMSException, TSPException, IOException {
        SignerId signerConstraints = token.getSID();
        HashSet<String> extKeyUsageSet = new HashSet<String>();
        extKeyUsageSet.add(KeyPurposeId.id_kp_timeStamping.getId());
        signerConstraints.setExtendedKeyUsage(extKeyUsageSet);
        CertStore certs = token.getCertificatesAndCRLs("Collection", provider.getName());
        Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
        Iterator<? extends Certificate> certIt = certCollection.iterator();
        if (certIt.hasNext()) {
            return (X509Certificate)certIt.next();
        }
        throw new TSPException("TSA-certificate not found");
    }

    public static void validateTimeStampToken(TimeStampToken token, byte[] data, Provider provider) throws NoSuchProviderException, TSPException, CertificateExpiredException, CertificateNotYetValidException, NoSuchAlgorithmException, CMSException, CertStoreException, ProviderUtilException, IOException {
        X509Certificate cert = TSPUtil.getTSPCertificate(token, provider);
        TimeStampTokenInfo tstInfo = token.getTimeStampInfo();
        byte[] digest = MessageDigest.getInstance(tstInfo.getMessageImprintAlgOID(), provider).digest(data);
        if (!Arrays.equals(digest, tstInfo.getMessageImprintDigest())) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.DIFF_HASH);
        }
        token.validate(cert, provider.getName());
    }
}

