/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import kz.gov.pki.kalkan.asn1.ASN1Object;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.DERBitString;
import kz.gov.pki.kalkan.asn1.DERIA5String;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROctetString;
import kz.gov.pki.kalkan.asn1.DERUTF8String;
import kz.gov.pki.kalkan.asn1.cryptopro.CryptoProObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.ocsp.OCSPObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.util.ASN1Dump;
import kz.gov.pki.kalkan.asn1.x509.CRLDistPoint;
import kz.gov.pki.kalkan.asn1.x509.DistributionPoint;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.asn1.x509.GeneralNames;
import kz.gov.pki.kalkan.asn1.x509.KeyPurposeId;
import kz.gov.pki.kalkan.asn1.x509.SubjectPublicKeyInfo;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.openssl.PEMWriter;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.kalkan.x509.extension.X509ExtensionUtil;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.FileUtil;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyUsageType;

public class X509Util {
    public static X509Certificate getX509Certificate(String pem, Provider provider) throws CertificateException, IOException {
        X509Certificate x509Certificate = null;
        CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes());){
            x509Certificate = (X509Certificate)cf.generateCertificate(stream);
        }
        if (x509Certificate == null) {
            throw new CertificateException("Unable to parse PEM to X509Certificate");
        }
        return x509Certificate;
    }

    public static X509Certificate getX509Certificate(byte[] bytes, Provider provider) throws CertificateException, IOException {
        X509Certificate x509Certificate = null;
        CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            x509Certificate = (X509Certificate)cf.generateCertificate(stream);
        }
        if (x509Certificate == null) {
            stream = new ByteArrayInputStream(Base64.decode(bytes));
            var5_5 = null;
            try {
                x509Certificate = (X509Certificate)cf.generateCertificate(stream);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var5_5 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        if (x509Certificate == null) {
            throw new CertificateException("Unable to parse array of bytes to X509Certificate");
        }
        return x509Certificate;
    }

    public static X509CRL getX509CRL(String pem, Provider provider) throws CRLException, CertificateException, IOException {
        X509CRL x509crl = null;
        CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(pem.getBytes());){
            x509crl = (X509CRL)cf.generateCRL(stream);
        }
        if (x509crl == null) {
            throw new CRLException("Unable to parse PEM to X509crl");
        }
        return x509crl;
    }

    public static X509CRL getX509CRL(byte[] bytes, Provider provider) throws CRLException, CertificateException, IOException {
        X509CRL x509crl = null;
        CertificateFactory cf = CertificateFactory.getInstance("X509", provider);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            x509crl = (X509CRL)cf.generateCRL(stream);
        }
        if (x509crl == null) {
            stream = new ByteArrayInputStream(Base64.decode(bytes));
            var5_5 = null;
            try {
                x509crl = (X509CRL)cf.generateCRL(stream);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (var5_5 != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        if (x509crl == null) {
            throw new CRLException("Unable to parse array of bytes to X509crl");
        }
        return x509crl;
    }

    public static X509Certificate loadX509Certificate(String absolutePath, Provider provider) throws CertificateException, IOException {
        return X509Util.getX509Certificate(FileUtil.readFile(absolutePath), provider);
    }

    public static X509Certificate loadX509Certificate(URL url, Provider provider) throws CertificateException, IOException {
        return X509Util.getX509Certificate(FileUtil.readFile(url), provider);
    }

    public static X509CRL loadX509CRL(String absolutePath, Provider provider) throws CRLException, CertificateException, IOException {
        return X509Util.getX509CRL(FileUtil.readFile(absolutePath), provider);
    }

    public static X509CRL loadX509CRL(URL url, Provider provider) throws CRLException, CertificateException, IOException {
        return X509Util.getX509CRL(FileUtil.readFile(url), provider);
    }

    public static String getPem(X509Certificate x509Certificate) throws IOException {
        String pem = null;
        try (StringWriter sw = new StringWriter();
             PEMWriter pemw = new PEMWriter(sw);){
            pemw.writeObject(x509Certificate);
            pemw.flush();
            pem = sw.toString();
        }
        return pem;
    }

    public static X509Name getSubjectDN(X509Certificate x509Certificate) {
        return new X509Name(x509Certificate.getSubjectDN().getName());
    }

    public static X509Name getSubjectDN(Map<String, String> rdns) throws ProviderUtilException {
        X509Util.validateSubjectDN(rdns);
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<String> values = new Vector<String>();
        for (String key : rdns.keySet()) {
            oids.add(new DERObjectIdentifier(key));
            values.add(X509Util.clearRdn(rdns.get(key)));
        }
        X509Name dn = new X509Name(oids, values);
        System.out.println("dn = " + dn);
        return dn;
    }

    public static X509Name getIssuerDN(X509Certificate x509Certificate) {
        return new X509Name(x509Certificate.getIssuerDN().getName());
    }

    public static byte[] getPublicKeyBytes(X509Certificate x509Certificate) throws IOException {
        ASN1Object pubKey = ASN1Object.fromByteArray(x509Certificate.getPublicKey().getEncoded());
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(pubKey);
        return subjectPublicKeyInfo.getPublicKeyData().getBytes();
    }

    public static String getRdn(X509Name x509Name, DERObjectIdentifier dERObjectIdentifier, int index) {
        try {
            return x509Name.getValues(dERObjectIdentifier).get(index).toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getKeyId(X509Certificate x509Certificate) throws IOException, ProviderUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static byte[] getAuthorityKeyIdentifier(X509Extension x509Extension) throws IOException, ProviderUtilException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<URL> getCrlURLs(X509Certificate x509Certificate, boolean isDelta) throws ProviderUtilException, MalformedURLException, IOException {
        DistributionPoint[] distPoints;
        byte[] extvalue;
        ArrayList<URL> urls = new ArrayList<URL>();
        byte[] byArray = extvalue = isDelta ? x509Certificate.getExtensionValue(X509Extensions.FreshestCRL.getId()) : x509Certificate.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (extvalue == null) {
            if (isDelta) {
                throw new ProviderUtilException(ProviderUtilExceptionCode.EXTENSION_NOT_FOUND, "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u0435\u0439\u0448\u0438\u0439 CRL\u00bb \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
            }
            throw new ProviderUtilException(ProviderUtilExceptionCode.EXTENSION_NOT_FOUND, "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u00ab\u0422\u043e\u0447\u043a\u0438 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u043e\u0442\u0437\u044b\u0432\u0430\u00bb \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
        CRLDistPoint crldp = CRLDistPoint.getInstance(X509ExtensionUtil.fromExtensionValue(extvalue));
        for (DistributionPoint dp : distPoints = crldp.getDistributionPoints()) {
            GeneralNames gns = (GeneralNames)dp.getDistributionPoint().getName();
            for (GeneralName name : gns.getNames()) {
                if (name.getTagNo() != 6) continue;
                DERIA5String uri = (DERIA5String)name.getName();
                urls.add(new URL(uri.getString()));
            }
        }
        return urls;
    }

    /*
     * Exception decompiling
     */
    public static List<String> getCertificatePolicyIdentifiers(X509Certificate x509Certificate) throws ProviderUtilException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String readExtension(X509Certificate x509Certificate, String oid) throws IOException, ProviderUtilException {
        if (oid.equals(X509Extensions.AuthorityKeyIdentifier.getId())) {
            return Hex.encodeStr(X509Util.getAuthorityKeyIdentifier(x509Certificate));
        }
        StringBuilder sb = new StringBuilder();
        byte[] bytes = x509Certificate.getExtensionValue(oid);
        if (bytes == null) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.EXTENSION_NOT_FOUND, "\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u00ab" + oid + "\u00bb \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
        ASN1Object asn1 = X509ExtensionUtil.fromExtensionValue(bytes);
        if (asn1 instanceof ASN1Sequence) {
            ASN1Sequence seq = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue(bytes);
            Enumeration secEnum = seq.getObjects();
            while (secEnum.hasMoreElements()) {
                sb.append(ASN1Dump.dumpAsString(secEnum.nextElement()));
            }
        } else if (asn1 instanceof DEROctetString) {
            DEROctetString oct = (DEROctetString)asn1;
            sb.append(Hex.encodeStr(oct.getOctets()));
        }
        if (asn1 instanceof DERUTF8String) {
            DERUTF8String u8 = DERUTF8String.getInstance(asn1);
            sb.append(u8.getString());
        } else if (asn1 instanceof DERBitString) {
            DERBitString d = DERBitString.getInstance(asn1);
            boolean[] b = X509Util.getBooleanArray(d.intValue());
            for (int i = 0; i < b.length; ++i) {
                if (!b[i]) continue;
                sb.append(KeyUsageType.get(i).name()).append(System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    public static HashMap<String, String> getRDNMap(X509Name x509Name) {
        HashMap<String, String> mapOidValue = new HashMap<String, String>();
        for (Object o : x509Name.getOIDs()) {
            DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)o;
            String oid = objectIdentifier.getId();
            String value = (String)x509Name.getValues(objectIdentifier).firstElement();
            mapOidValue.put(oid, value);
        }
        return mapOidValue;
    }

    public static HashMap<String, String[]> getRDNMapWithArrayValues(X509Name x509Name) {
        HashMap<String, String[]> mapOidValue = new HashMap<String, String[]>();
        for (Object o : x509Name.getOIDs()) {
            DERObjectIdentifier objectIdentifier = (DERObjectIdentifier)o;
            String oid = objectIdentifier.getId();
            Object[] values = new Object[x509Name.getValues(objectIdentifier).size()];
            x509Name.getValues(objectIdentifier).copyInto(values);
            String[] valuesStr = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                valuesStr[i] = (String)values[i];
            }
            mapOidValue.put(oid, valuesStr);
        }
        return mapOidValue;
    }

    public static boolean containsKeyUsage(X509Certificate cert, KeyUsageType keyUsageType) {
        boolean[] usages = cert.getKeyUsage();
        for (int i = 0; i < usages.length; ++i) {
            if (i != keyUsageType.getIntValue()) continue;
            if (!usages[i]) break;
            return true;
        }
        return false;
    }

    public static boolean containsExtKeyUsage(X509Certificate cert, String extKeyUsageOid) throws CertificateParsingException {
        List<String> extendedKeyUsages = cert.getExtendedKeyUsage();
        if (extendedKeyUsages != null) {
            for (String s : cert.getExtendedKeyUsage()) {
                if (!s.equals(extKeyUsageOid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOCSPNonCheck(X509Certificate x509Certificate) {
        return x509Certificate.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck.getId()) != null;
    }

    public static Set<KNCACertificateType> getKNCACertificateType(X509Certificate x509Certificate) throws IOException, ProviderUtilException, CertificateParsingException {
        HashSet<KNCACertificateType> result;
        block9: {
            result = new HashSet<KNCACertificateType>();
            List<Object> certificatePolicyIdentifiers = new ArrayList();
            try {
                certificatePolicyIdentifiers = X509Util.getCertificatePolicyIdentifiers(x509Certificate);
            }
            catch (ProviderUtilException e) {
                if (e.getCode().equals((Object)ProviderUtilExceptionCode.EXTENSION_NOT_FOUND)) break block9;
                throw e;
            }
        }
        if (X509Util.containsKeyUsage(x509Certificate, KeyUsageType.DIGITAL_SIGNATURE) && X509Util.containsKeyUsage(x509Certificate, KeyUsageType.NONREPUDIATION)) {
            result.add(KNCACertificateType.SIGNATURE);
            if (x509Certificate.getSigAlgOID().equals(KNCAObjectIdentifiers.gost3411_2015_with_gost3410_2015_512.getId())) {
                result.add(KNCACertificateType.AUTHENTICATION);
            }
        }
        if (X509Util.containsKeyUsage(x509Certificate, KeyUsageType.DIGITAL_SIGNATURE) && X509Util.containsKeyUsage(x509Certificate, KeyUsageType.KEY_ENCIPHERMENT) && X509Util.containsExtKeyUsage(x509Certificate, KeyPurposeId.id_kp_clientAuth.getId())) {
            result.add(KNCACertificateType.AUTHENTICATION);
        }
        if (X509Util.containsKeyUsage(x509Certificate, KeyUsageType.DIGITAL_SIGNATURE) && X509Util.containsKeyUsage(x509Certificate, KeyUsageType.KEY_ENCIPHERMENT) && X509Util.containsExtKeyUsage(x509Certificate, KeyPurposeId.id_kp_serverAuth.getId())) {
            result.add(KNCACertificateType.SSL);
        }
        if (X509Util.containsOCSPNonCheck(x509Certificate) && X509Util.containsExtKeyUsage(x509Certificate, KeyPurposeId.id_kp_OCSPSigning.getId())) {
            result.add(KNCACertificateType.OCSP_RESPONSE_SIGNING);
        }
        if (X509Util.containsExtKeyUsage(x509Certificate, KeyPurposeId.id_kp_timeStamping.getId())) {
            result.add(KNCACertificateType.TSP_SIGNING);
        }
        if (result.size() < 1) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.UNKNOWN_KNCA_CERTIFICATE_TYPE);
        }
        return result;
    }

    @Deprecated
    public static boolean isExCaCert(X509Certificate cert) {
        return cert.getSigAlgOID().equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId()) || cert.getSigAlgOID().equals(CryptoProObjectIdentifiers.gostR3411_94_with_gostR34310_2004.getId());
    }

    private static void validateSubjectDN(Map<String, String> rdns) throws ProviderUtilException {
        String iin = rdns.get(X509Name.SERIALNUMBER.getId());
        String bin = rdns.get(X509Name.OU.getId());
        String country = rdns.get(X509Name.C.getId());
        if (!(iin == null || iin.startsWith("IIN") && iin.length() == 15)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "Incorrect values within DN:\nIIN = " + iin);
        }
        if (!(bin == null || bin.startsWith("BIN") && bin.length() == 15)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "Incorrect values within DN:\nBIN = " + bin);
        }
        if (country != null && !country.equals("KZ")) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.INCORRECT_SUBJECTDN_VALUE, "Error: Incorrect values within DN:\nC = " + country);
        }
    }

    private static String clearRdn(String value) {
        return value.replaceAll("\\r\\n|\\r|\\n", " ").replaceAll("\\s+", " ").toUpperCase().trim();
    }

    private static boolean[] getBooleanArray(int i) {
        String ss = Integer.toBinaryString(i);
        boolean[] keyUsageArray = new boolean[9];
        if (i < 32768) {
            int counter = 0;
            for (char c : ss.toCharArray()) {
                if (c == '1' && counter < 9) {
                    keyUsageArray[counter] = true;
                }
                ++counter;
            }
        } else {
            keyUsageArray[8] = true;
            int counter = 0;
            for (char c : ss.toCharArray()) {
                if (c == '1' && counter > 7) {
                    keyUsageArray[counter - 8] = true;
                }
                ++counter;
            }
        }
        return keyUsageArray;
    }

    public static DERObjectIdentifier getKeystoreOid(X509Certificate cert) throws IOException {
        byte[] keystoreOidExt = cert.getExtensionValue(KNCAObjectIdentifiers.keystore_branch.getId());
        if (keystoreOidExt != null) {
            ASN1OctetString octetString = ASN1OctetString.getInstance(ASN1Object.fromByteArray(keystoreOidExt));
            ASN1Sequence sequence = ASN1Sequence.getInstance(ASN1Object.fromByteArray(octetString.getOctets()));
            return DERObjectIdentifier.getInstance(sequence.getObjectAt(0));
        }
        return null;
    }
}

