/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.knca.KNCAObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.GeneralName;
import kz.gov.pki.kalkan.asn1.x509.GeneralNames;
import kz.gov.pki.kalkan.asn1.x509.IssuerSerial;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.tsp.TSPException;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.TSPUtil;
import kz.gov.pki.provider.utils.XMLUtil;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XADESUtil {
    public static final String XADES_SIGNED_PROPERTIES_URI = "http://uri.etsi.org/01903#SignedProperties";
    public static final String XADES = "xades";
    public static final String DS = "ds";
    public static final String DS_ = "ds:";
    public static final String XADES_ = "xades:";
    public static final String XADES_CERT = "xades:Cert";
    public static final String XADES_CERT_DIGEST = "xades:CertDigest";
    public static final String XADES_ENCAPSULATED_TIME_STAMP = "xades:EncapsulatedTimeStamp";
    public static final String XADES_ISSUER_SERIAL_V2 = "xades:IssuerSerialV2";
    public static final String XADES_QUALIFYING_PROPERTIES = "xades:QualifyingProperties";
    public static final String XADES_SIGNATURE_TIME_STAMP = "xades:SignatureTimeStamp";
    public static final String XADES_SIGNED_PROPERTIES = "xades:SignedProperties";
    public static final String XADES_SIGNED_SIGNATURE_PROPERTIES = "xades:SignedSignatureProperties";
    public static final String XADES_SIGNING_CERTIFICATE_V2 = "xades:SigningCertificateV2";
    public static final String XADES_UNSIGNED_PROPERTIES = "xades:UnsignedProperties";
    public static final String XADES_UNSIGNED_SIGNATURE_PROPERTIES = "xades:UnsignedSignatureProperties";
    public static final String XADES_SIGNING_TIME = "xades:SigningTime";
    public static final String XADES_132_URI = "http://uri.etsi.org/01903/v1.3.2#";
    private TimeStampToken timeStampToken;
    private X509Certificate signerCert;

    public String createXAdES(String xmlSource, KeyStore keyStore, String alias, char[] password, Provider provider) throws ParserConfigurationException, SAXException, IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, XMLSecurityException, CertificateExpiredException, CertificateNotYetValidException, NoSuchProviderException, CertStoreException, TSPException, CMSException, ProviderUtilException, TransformerException, CertificateEncodingException {
        KalkanHashAlgorithm hashAlg;
        String digestMethod;
        String signMethod;
        String ret = "";
        Document doc = XMLUtil.getDocument(xmlSource);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password);
        X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
        String sigAlgOid = cert.getSigAlgOID();
        if (sigAlgOid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha1";
            digestMethod = "http://www.w3.org/2001/04/xmldsig-more#sha1";
            hashAlg = KalkanHashAlgorithm.HASH_SHA1;
        } else if (sigAlgOid.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
            digestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
            hashAlg = KalkanHashAlgorithm.HASH_SHA256;
        } else if (sigAlgOid.equals(KNCAObjectIdentifiers.gost34311_95_with_gost34310_2004.getId())) {
            signMethod = "http://www.w3.org/2001/04/xmldsig-more#gost34310-gost34311";
            digestMethod = "http://www.w3.org/2001/04/xmldsig-more#gost34311";
            hashAlg = KalkanHashAlgorithm.HASH_GOST34311;
        } else {
            signMethod = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34102015-gostr34112015-512";
            digestMethod = "urn:ietf:params:xml:ns:pkigovkz:xmlsec:algorithms:gostr34112015-512";
            hashAlg = KalkanHashAlgorithm.HASH_GOST3411_2015_512;
        }
        XMLSignature xs = new XMLSignature(doc, "", signMethod);
        UUID uuid = UUID.randomUUID();
        String sigid = "sig-" + uuid;
        xs.setId(sigid);
        Transforms trans = new Transforms(doc);
        trans.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        trans.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        xs.addKeyInfo(cert);
        xs.addDocument("", trans, digestMethod, sigid + "-ref0", null);
        Element sigEl = xs.getElement();
        doc.getDocumentElement().appendChild(sigEl);
        Element qualPropsEl = doc.createElementNS(XADES_132_URI, XADES_QUALIFYING_PROPERTIES);
        XMLUtils.addReturnToElement(qualPropsEl);
        Element sigPropsEl = doc.createElement(XADES_SIGNED_PROPERTIES);
        XMLUtils.addReturnToElement(sigPropsEl);
        Element sigSigPropsEl = doc.createElement(XADES_SIGNED_SIGNATURE_PROPERTIES);
        XMLUtils.addReturnToElement(sigSigPropsEl);
        Element sigTimeEl = doc.createElement(XADES_SIGNING_TIME);
        Element sigCertV2El = doc.createElement(XADES_SIGNING_CERTIFICATE_V2);
        XMLUtils.addReturnToElement(sigCertV2El);
        Element certEl = doc.createElement(XADES_CERT);
        XMLUtils.addReturnToElement(certEl);
        Element certDigestEl = doc.createElement(XADES_CERT_DIGEST);
        XMLUtils.addReturnToElement(certDigestEl);
        Element digMethodEl = doc.createElement("ds:DigestMethod");
        Element digValueEl = doc.createElement("ds:DigestValue");
        Element issuerSerialV2El = doc.createElement(XADES_ISSUER_SERIAL_V2);
        Element unsigPropsEl = doc.createElement(XADES_UNSIGNED_PROPERTIES);
        XMLUtils.addReturnToElement(unsigPropsEl);
        Element unsigSigPropsEl = doc.createElement(XADES_UNSIGNED_SIGNATURE_PROPERTIES);
        XMLUtils.addReturnToElement(unsigSigPropsEl);
        Element sigTSEl = doc.createElement(XADES_SIGNATURE_TIME_STAMP);
        XMLUtils.addReturnToElement(sigTSEl);
        Element canMethodEl = doc.createElement("ds:CanonicalizationMethod");
        Element encapTSEl = doc.createElement(XADES_ENCAPSULATED_TIME_STAMP);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sigTimeEl.setTextContent(sdf.format(new Date()));
        IssuerSerial issuerSerial = this.buildIssuerSerial(cert);
        byte[] certDig = MessageDigest.getInstance(hashAlg.getId(), provider).digest(cert.getEncoded());
        digMethodEl.setAttribute("Algorithm", digestMethod);
        digValueEl.setTextContent(Base64.encodeStr(certDig));
        issuerSerialV2El.setTextContent(Base64.encodeStr(issuerSerial.getEncoded()));
        certDigestEl.appendChild(digMethodEl);
        certDigestEl.appendChild(digValueEl);
        certEl.appendChild(certDigestEl);
        certEl.appendChild(issuerSerialV2El);
        sigCertV2El.appendChild(certEl);
        String sigpropsid = sigid + "-sigprops";
        sigPropsEl.setAttribute("Id", sigpropsid);
        sigPropsEl.setIdAttribute("Id", true);
        sigSigPropsEl.appendChild(sigTimeEl);
        sigSigPropsEl.appendChild(sigCertV2El);
        sigPropsEl.appendChild(sigSigPropsEl);
        qualPropsEl.setAttribute("Target", "#" + sigid);
        qualPropsEl.appendChild(sigPropsEl);
        ObjectContainer objCon = new ObjectContainer(doc);
        objCon.appendChild(qualPropsEl);
        xs.appendObject(objCon);
        Transforms trans2 = new Transforms(doc);
        trans2.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        xs.addDocument("#" + sigpropsid, trans2, digestMethod, null, XADES_SIGNED_PROPERTIES_URI);
        xs.sign(privateKey);
        canMethodEl.setAttribute("Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        Element sigValEl = this.getElementByTagName(xs.getElement(), "ds:SignatureValue");
        Canonicalizer canonicalizer = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] sigVal = canonicalizer.canonicalizeSubtree(sigValEl);
        TSAProfile tsaProfile = new TSAProfile();
        tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_GOST34311);
        tsaProfile.setTsaPolicy(TSAPolicy.TSA_GOST);
        TimeStampToken tsToken = TSPUtil.getTimeStampResponse(sigVal, tsaProfile, provider).getTimeStampToken();
        encapTSEl.setTextContent(Base64.encodeStr(tsToken.getEncoded()));
        sigTSEl.appendChild(canMethodEl);
        sigTSEl.appendChild(encapTSEl);
        unsigSigPropsEl.appendChild(sigTSEl);
        unsigPropsEl.appendChild(unsigSigPropsEl);
        qualPropsEl.appendChild(unsigPropsEl);
        StringWriter os = new StringWriter();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(os));
        os.close();
        ret = os.toString();
        return ret;
    }

    private IssuerSerial buildIssuerSerial(X509Certificate cert) {
        X509Name issuerName = new X509Name(cert.getIssuerDN().getName());
        GeneralName generalName = new GeneralName(issuerName);
        GeneralNames generalNames = new GeneralNames(generalName);
        return new IssuerSerial(generalNames, new DERInteger(cert.getSerialNumber()));
    }

    public boolean verifyXAdES(String xml, Provider provider) throws ParserConfigurationException, SAXException, IOException, XMLSignatureException, XMLSecurityException, ProviderUtilException, DOMException, TSPException, CMSException, CertificateExpiredException, CertificateNotYetValidException, NoSuchProviderException, NoSuchAlgorithmException, CertStoreException, CertificateEncodingException {
        boolean ret = false;
        Document doc = XMLUtil.getDocument(xml);
        Element sigEl = (Element)doc.getFirstChild().getLastChild();
        XMLSignature xs = new XMLSignature(sigEl, "");
        Element sigValEl = this.getElementByTagName(sigEl, "ds:SignatureValue");
        Element qualPropsEl = this.getElementByTagName(xs.getElement(), XADES_QUALIFYING_PROPERTIES);
        Element sigPropsEl = this.getElementByTagName(qualPropsEl, XADES_SIGNED_PROPERTIES);
        Element sigCertV2El = this.getElementByTagName(sigPropsEl, XADES_SIGNING_CERTIFICATE_V2);
        Element digMethodEl = this.getElementByTagName(sigCertV2El, "ds:DigestMethod");
        String digMethod = JCEMapper.translateURItoJCEID(digMethodEl.getAttribute("Algorithm"));
        Element digValEl = this.getElementByTagName(sigCertV2El, "ds:DigestValue");
        Element issuerSerialV2El = this.getElementByTagName(sigCertV2El, XADES_ISSUER_SERIAL_V2);
        sigPropsEl.setIdAttribute("Id", true);
        this.signerCert = xs.getKeyInfo().getX509Certificate();
        ret = xs.checkSignatureValue(this.signerCert);
        byte[] signerCertHash = MessageDigest.getInstance(digMethod, provider).digest(this.signerCert.getEncoded());
        byte[] digVal = Base64.decode(digValEl.getTextContent());
        if (!Arrays.equals(signerCertHash, digVal)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_ESSCERTIDV2_DIFF_CERTHASH);
        }
        DERObject derObj = null;
        try (ASN1InputStream asn1Is = new ASN1InputStream(Base64.decode(issuerSerialV2El.getTextContent()));){
            derObj = asn1Is.readObject();
        }
        IssuerSerial issuerSerialV2 = IssuerSerial.getInstance(derObj);
        IssuerSerial signerCertISV2 = this.buildIssuerSerial(this.signerCert);
        if (!signerCertISV2.equals(issuerSerialV2)) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.DIFF_ISSUER_SERIAL);
        }
        Element unsigPropsEl = this.getElementByTagName(qualPropsEl, XADES_UNSIGNED_PROPERTIES);
        Element sigTSEl = this.getElementByTagName(unsigPropsEl, XADES_SIGNATURE_TIME_STAMP);
        Element canMethodEl = this.getElementByTagName(sigTSEl, "ds:CanonicalizationMethod");
        Element encapTSEl = this.getElementByTagName(sigTSEl, XADES_ENCAPSULATED_TIME_STAMP);
        this.timeStampToken = new TimeStampToken(new CMSSignedData(Base64.decode(encapTSEl.getTextContent())));
        Canonicalizer canonicalizer = Canonicalizer.getInstance(canMethodEl.getAttribute("Algorithm"));
        byte[] canSigVal = canonicalizer.canonicalizeSubtree(sigValEl);
        TSPUtil.validateTimeStampToken(this.timeStampToken, canSigVal, provider);
        return ret;
    }

    private Element getElementByTagName(Element element, String tagName) throws ProviderUtilException {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList.getLength() != 1) {
            throw new ProviderUtilException(ProviderUtilExceptionCode.XML_TAG_NOT_FOUND);
        }
        return (Element)nodeList.item(0);
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }
}

