/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.provider.utils.verifier;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.jce.exception.ExtCertPathValidatorException;
import kz.gov.pki.kalkan.ocsp.CertificateStatus;
import kz.gov.pki.kalkan.ocsp.OCSPException;
import kz.gov.pki.kalkan.ocsp.RevokedStatus;
import kz.gov.pki.kalkan.ocsp.UnknownStatus;
import kz.gov.pki.kalkan.util.encoders.Hex;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.OCSPUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.provider.utils.verifier.VerifierResult;
import kz.gov.pki.provider.utils.verifier.VerifierResultCode;
import kz.gov.pki.provider.utils.verifier.VerifierType;
import kz.gov.pki.provider.utils.verifier.VerifyX509CertifcateResult;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;

public class Verifier {
    public static VerifyX509CertifcateResult verifyX509Certificate(X509Certificate x509Certificate, Collection<X509Certificate> caCertList, VerifierFlags verifyerFlags) throws CertificateParsingException, CertificateException, IOException, NoSuchAlgorithmException, NoSuchProviderException, ProviderUtilException, InvalidAlgorithmParameterException, CertPathBuilderException {
        return Verifier.verifyX509Certificate(x509Certificate, caCertList, null, verifyerFlags);
    }

    public static VerifyX509CertifcateResult verifyX509Certificate(X509Certificate x509Certificate, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, VerifierFlags verifyerFlags) throws CertificateParsingException, CertificateException, IOException, NoSuchAlgorithmException, NoSuchProviderException, ProviderUtilException, InvalidAlgorithmParameterException, CertPathBuilderException {
        VerifierResult vResult;
        VerifyX509CertifcateResult result = new VerifyX509CertifcateResult();
        X509Name x509Name = X509Util.getSubjectDN(x509Certificate);
        X509Name issuerX509Name = X509Util.getIssuerDN(x509Certificate);
        result.setX509Certificate(x509Certificate);
        result.setListExtKeyUsageOid(x509Certificate.getExtendedKeyUsage());
        result.setSubjectDN(x509Name.toString());
        result.setIssuerDN(issuerX509Name.toString());
        result.setIssuerCommonName(X509Util.getRdn(issuerX509Name, X509Name.CN, 0));
        result.setMapRdnOidValue(X509Util.getRDNMapWithArrayValues(x509Name));
        result.setSerialNumber(x509Certificate.getSerialNumber().toString(16));
        result.setAuthorityKeyIdentifier(Hex.encodeStr(X509Util.getAuthorityKeyIdentifier(x509Certificate)));
        result.setSubjectKeyIdentifier(X509Util.getKeyId(x509Certificate));
        result.setCurrentVerificationType(verifyerFlags.getCurrentVerificationType());
        result.setSetKNCACertificateType(X509Util.getKNCACertificateType(x509Certificate));
        String iin = result.getIin();
        String bin = result.getBin();
        result.setPersonCert(X509Util.containsExtKeyUsage(x509Certificate, "1.2.398.3.3.4.1.1"));
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_TYPE_AUTHENTICATION)) {
            result.addVerifierResult(Verifier.verifyKNCACertificateTypeAuthentication(x509Certificate, result.getSetKNCACertificateType()));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_TYPE_SIGNATURE)) {
            result.addVerifierResult(Verifier.verifyKNCACertificateTypeSignature(x509Certificate, result.getSetKNCACertificateType()));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAAdministrator(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_MANAGER)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAManager(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_OPERATOR)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAOperator(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_COMPANY_HEAD)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCACompanyHead(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_KNCA_USER)) {
            result.addVerifierResult(Verifier.verifyKNCAUser(x509Certificate, result.getAuthorityKeyIdentifier(), iin, bin));
        }
        if (result.isValid() && (vResult = Verifier.verifyChain(x509Certificate, caCertList, crlList, verifyerFlags)) != null) {
            result.addVerifierResult(vResult);
        }
        return result;
    }

    @Deprecated
    public static VerifyX509CertifcateResult verifyX509Certificate(X509Certificate x509Certificate, Map<String, X509Certificate> mapCaCert, Provider provider, URL ocspUrl, VerifierFlags verifyerFlags) throws CertificateParsingException, CertificateException, IOException, NoSuchAlgorithmException, NoSuchProviderException, OCSPException, ProviderUtilException {
        VerifyX509CertifcateResult result = new VerifyX509CertifcateResult();
        X509Name x509Name = X509Util.getSubjectDN(x509Certificate);
        X509Name issuerX509Name = X509Util.getIssuerDN(x509Certificate);
        result.setX509Certificate(x509Certificate);
        result.setListExtKeyUsageOid(x509Certificate.getExtendedKeyUsage());
        result.setSubjectDN(x509Name.toString());
        result.setIssuerDN(issuerX509Name.toString());
        result.setIssuerCommonName(X509Util.getRdn(issuerX509Name, X509Name.CN, 0));
        result.setMapRdnOidValue(X509Util.getRDNMapWithArrayValues(x509Name));
        result.setSerialNumber(x509Certificate.getSerialNumber().toString(16));
        result.setAuthorityKeyIdentifier(Hex.encodeStr(X509Util.getAuthorityKeyIdentifier(x509Certificate)));
        result.setSubjectKeyIdentifier(X509Util.getKeyId(x509Certificate));
        result.setCurrentVerificationType(verifyerFlags.getCurrentVerificationType());
        result.setSetKNCACertificateType(X509Util.getKNCACertificateType(x509Certificate));
        String iin = result.getIin();
        String bin = result.getBin();
        if (X509Util.isExCaCert(x509Certificate)) {
            result.setPersonCert(bin == null);
        } else {
            result.setPersonCert(X509Util.containsExtKeyUsage(x509Certificate, "1.2.398.3.3.4.1.1"));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_TIME_VALIDITY)) {
            result.addVerifierResult(Verifier.verifyTimeValidity(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_TYPE_AUTHENTICATION)) {
            result.addVerifierResult(Verifier.verifyKNCACertificateTypeAuthentication(x509Certificate, result.getSetKNCACertificateType()));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_TYPE_SIGNATURE)) {
            result.addVerifierResult(Verifier.verifyKNCACertificateTypeSignature(x509Certificate, result.getSetKNCACertificateType()));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAAdministrator(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_MANAGER)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAManager(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_OPERATOR)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCAOperator(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_COMPANY_HEAD)) {
            result.addVerifierResult(Verifier.verifyExtKeyUsageKNCACompanyHead(x509Certificate));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_KNCA_USER)) {
            result.addVerifierResult(Verifier.verifyKNCAUser(x509Certificate, result.getAuthorityKeyIdentifier(), iin, bin));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CHAIN)) {
            result.addVerifierResult(Verifier.verifyChain(x509Certificate, mapCaCert, result.getAuthorityKeyIdentifier(), provider, verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_CACERT_TIME_VALIDITY)));
        }
        if (result.isValid() && verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_OCSP_STATUS)) {
            result.addVerifierResult(Verifier.verifyOCSPStatus(x509Certificate, mapCaCert, result.getAuthorityKeyIdentifier(), provider, ocspUrl));
        }
        return result;
    }

    public static VerifierResult verifyTimeValidity(X509Certificate cert) {
        VerifierResult vr;
        try {
            cert.checkValidity();
            vr = new VerifierResult(VerifierType.X509CERTIFICATE_TIME_VALIDITY, VerifierResultCode.SUCCESS);
        }
        catch (CertificateExpiredException e) {
            vr = new VerifierResult(VerifierType.X509CERTIFICATE_TIME_VALIDITY, VerifierResultCode.X509CERTIFICATE_VALIDITY_EXPIRED);
        }
        catch (CertificateNotYetValidException e) {
            vr = new VerifierResult(VerifierType.X509CERTIFICATE_TIME_VALIDITY, VerifierResultCode.X509CERTIFICATE_VALIDITY_NOT_YET_VALID);
        }
        return vr;
    }

    public static VerifierResult verifyExtKeyUsageKNCAAdministrator(X509Certificate cert) throws CertificateParsingException {
        VerifierResult vr = X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.2.1") ? new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_ADMINISTRATOR_FAIL);
        return vr;
    }

    public static VerifierResult verifyKNCACertificateTypeSignature(X509Certificate cert, Set<KNCACertificateType> types) throws IOException, ProviderUtilException, CertificateParsingException {
        if (types == null) {
            types = X509Util.getKNCACertificateType(cert);
        }
        VerifierResult vr = types.contains((Object)KNCACertificateType.SIGNATURE) ? new VerifierResult(VerifierType.X509CERTIFICATE_TYPE_SIGNATURE, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_TYPE_SIGNATURE, VerifierResultCode.X509CERTIFICATE_TYPE_SIGNATURE_FAIL);
        return vr;
    }

    public static VerifierResult verifyKNCACertificateTypeAuthentication(X509Certificate cert, Set<KNCACertificateType> types) throws IOException, ProviderUtilException, CertificateParsingException {
        if (types == null) {
            types = X509Util.getKNCACertificateType(cert);
        }
        VerifierResult vr = types.contains((Object)KNCACertificateType.AUTHENTICATION) ? new VerifierResult(VerifierType.X509CERTIFICATE_TYPE_AUTHENTICATION, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_TYPE_AUTHENTICATION, VerifierResultCode.X509CERTIFICATE_TYPE_AUTHENTICATION_FAIL);
        return vr;
    }

    public static VerifierResult verifyExtKeyUsageKNCAManager(X509Certificate cert) throws CertificateParsingException {
        VerifierResult vr = X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.2.2") ? new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_MANAGER, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_MANAGER, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_MANAGER_FAIL);
        return vr;
    }

    public static VerifierResult verifyExtKeyUsageKNCAOperator(X509Certificate cert) throws CertificateParsingException {
        VerifierResult vr = X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.2.3") ? new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_OPERATOR, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_OPERATOR, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_OPERATOR_FAIL);
        return vr;
    }

    public static VerifierResult verifyExtKeyUsageKNCACompanyHead(X509Certificate cert) throws CertificateParsingException {
        VerifierResult vr = X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.1.2.1") ? new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_COMPANY_HEAD, VerifierResultCode.SUCCESS) : new VerifierResult(VerifierType.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_COMPANY_HEAD, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_COMPANY_HEAD_FAIL);
        return vr;
    }

    public static VerifierResult verifyKNCAUser(X509Certificate cert, String authorityKeyIdentifier, String iin, String bin) throws CertificateParsingException {
        boolean isPerson = false;
        boolean isCompany = false;
        if (X509Util.isExCaCert(cert)) {
            isCompany = bin != null && !bin.isEmpty();
            isPerson = !isCompany;
        } else {
            if (X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.1.1")) {
                isPerson = true;
            }
            if (X509Util.containsExtKeyUsage(cert, "1.2.398.3.3.4.1.2")) {
                isCompany = true;
            }
            if (isPerson && isCompany) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_KNCA_USER, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_BOTH_PERSON_COMPANY);
            }
            if (!isCompany && !isPerson) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_KNCA_USER, VerifierResultCode.X509CERTIFICATE_CONTAINS_EXT_KEY_USAGE_KNCA_NONE_PERSON_COMPANY);
            }
        }
        if (iin == null || iin.isEmpty()) {
            return new VerifierResult(VerifierType.X509CERTIFICATE_KNCA_USER, VerifierResultCode.X509CERTIFICATE_CONTAINS_NONE_RDN_SERIALNUMBER);
        }
        if (isCompany && (bin == null || bin.isEmpty())) {
            return new VerifierResult(VerifierType.X509CERTIFICATE_KNCA_USER, VerifierResultCode.X509CERTIFICATE_CONTAINS_NONE_RDN_OU);
        }
        return new VerifierResult(VerifierType.X509CERTIFICATE_KNCA_USER, VerifierResultCode.SUCCESS);
    }

    @Deprecated
    public static VerifierResult verifyChain(X509Certificate cert, Map<String, X509Certificate> mapCaCert, String authorityKeyIdentifier, Provider provider, boolean caCertTimeValidity) throws IOException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException, ProviderUtilException {
        X509Certificate signedCert = null;
        String signedCertAuthorityKeyIdentifier = null;
        X509Certificate caCert = null;
        String caCertAuthorityKeyIdentifier = null;
        boolean verified = false;
        do {
            block10: {
                signedCert = signedCert == null ? cert : mapCaCert.get(signedCertAuthorityKeyIdentifier);
                caCert = mapCaCert.get(signedCertAuthorityKeyIdentifier = signedCertAuthorityKeyIdentifier == null ? authorityKeyIdentifier : caCertAuthorityKeyIdentifier);
                if (caCert == null) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_CHAIN, VerifierResultCode.CA_CERT_NOT_FOUND);
                }
                try {
                    caCertAuthorityKeyIdentifier = Hex.encodeStr(X509Util.getAuthorityKeyIdentifier(caCert));
                }
                catch (ProviderUtilException pue) {
                    if (!pue.getCode().equals((Object)ProviderUtilExceptionCode.EXTENSION_NOT_FOUND)) break block10;
                    caCertAuthorityKeyIdentifier = signedCertAuthorityKeyIdentifier;
                }
            }
            if (caCertTimeValidity) {
                try {
                    caCert.checkValidity();
                }
                catch (CertificateExpiredException e) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_CHAIN, VerifierResultCode.CA_CERT_VALIDITY_EXPIRED);
                }
                catch (CertificateNotYetValidException e) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_CHAIN, VerifierResultCode.CA_CERT_VALIDITY_NOT_YET_VALID);
                }
            }
            try {
                signedCert.verify(caCert.getPublicKey(), provider.getName());
            }
            catch (InvalidKeyException | SignatureException e) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_CHAIN, VerifierResultCode.X509CERTIFICATE_INVALID_CHAIN);
            }
        } while (!(verified = signedCert.equals(caCert)));
        return new VerifierResult(VerifierType.X509CERTIFICATE_CHAIN, VerifierResultCode.SUCCESS);
    }

    public static VerifierResult verifyChain(X509Certificate x509Certificate, Collection<X509Certificate> caCertList, Collection<X509CRL> crlList, VerifierFlags verifyerFlags) throws CertPathBuilderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, ProviderUtilException {
        try {
            if (verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_VALIDITY_ALLOW_EXPIRED)) {
                PKIXUtil pkixUtil = new PKIXUtil(x509Certificate, caCertList);
                pkixUtil.allowExpired().validate();
                return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY_ALLOW_EXPIRED, VerifierResultCode.SUCCESS);
            }
            if (verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_VALIDITY_WITH_STATUS)) {
                PKIXUtil pkixUtil = new PKIXUtil(x509Certificate, caCertList);
                pkixUtil = crlList == null ? pkixUtil.withOCSP() : pkixUtil.withCRL(crlList);
                pkixUtil.validate();
                return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY_WITH_STATUS, VerifierResultCode.SUCCESS);
            }
            if (verifyerFlags.containsVerifierType(VerifierType.X509CERTIFICATE_VALIDITY)) {
                PKIXUtil pkixUtil = new PKIXUtil(x509Certificate, caCertList);
                pkixUtil.validate();
                return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.SUCCESS);
            }
            return null;
        }
        catch (ProviderUtilException pue) {
            CertPathBuilderException e;
            if (pue.getCause() != null && pue.getCause() instanceof CertPathBuilderException && (e = (CertPathBuilderException)pue.getCause()).getCause() != null && e.getCause() instanceof ExtCertPathValidatorException) {
                CertPathValidatorException eee;
                ExtCertPathValidatorException ee = (ExtCertPathValidatorException)e.getCause();
                if (ee.getCause() != null && ee.getCause() instanceof CertificateExpiredException) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_VALIDITY_EXPIRED);
                }
                if (ee.getCause() != null && ee.getCause() instanceof CertificateNotYetValidException) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_VALIDITY_NOT_YET_VALID);
                }
                if (ee.getCause() != null && ee.getCause() instanceof CertPathValidatorException && (eee = (CertPathValidatorException)ee.getCause()).getCause() != null && eee.getCause() instanceof KalkanException) {
                    KalkanException ke = (KalkanException)eee.getCause();
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                        return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_OCSP_STATUS_REVOKED);
                    }
                    if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                        return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_OCSP_STATUS_UNKNOWN);
                    }
                    if (ke.getErrorCode().equals(OCSPCode.NONCES_NOT_EQUAL)) {
                        return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_OCSP_NOT_EQUAL_NONCES);
                    }
                    if (ke.getErrorCode().equals(OCSPCode.OCSP_RESP_NOT_VERIFIED)) {
                        return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_OCSP_RESPONSE_NOT_VERIFIED);
                    }
                }
                if (ee.getCause() != null && ee.getCause() instanceof InvalidKeyException) {
                    return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_INVALID_CHAIN);
                }
            }
            if (pue.getCode().equals((Object)ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND)) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_VALIDITY, VerifierResultCode.X509CERTIFICATE_INVALID_CHAIN);
            }
            throw pue;
        }
    }

    @Deprecated
    public static VerifierResult verifyOCSPStatus(X509Certificate cert, Map<String, X509Certificate> mapCaCert, String authorityKeyIdentifier, Provider provider, URL ocspUrl) throws IOException, OCSPException, NoSuchProviderException {
        try {
            X509Certificate caCert = mapCaCert.get(authorityKeyIdentifier);
            CertificateStatus status = OCSPUtil.verify(cert, caCert, ocspUrl, KalkanHashAlgorithm.HASH_SHA1, KNCAServiceRequestMethod.GET, false, provider);
            if (status == null) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_OCSP_STATUS, VerifierResultCode.SUCCESS);
            }
            if (status instanceof RevokedStatus && ((RevokedStatus)status).hasRevocationReason()) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_OCSP_STATUS, VerifierResultCode.X509CERTIFICATE_OCSP_STATUS_REVOKED);
            }
            if (status instanceof UnknownStatus) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_OCSP_STATUS, VerifierResultCode.X509CERTIFICATE_OCSP_STATUS_UNKNOWN);
            }
            throw new OCSPException("Unknown status");
        }
        catch (ProviderUtilException e) {
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.OCSP_NOT_EQUAL_NONCES)) {
                return new VerifierResult(VerifierType.X509CERTIFICATE_OCSP_STATUS, VerifierResultCode.X509CERTIFICATE_OCSP_NOT_EQUAL_NONCES);
            }
            return new VerifierResult(VerifierType.X509CERTIFICATE_OCSP_STATUS, VerifierResultCode.X509CERTIFICATE_OCSP_RESPONSE_NOT_VERIFIED);
        }
    }
}

