/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.extension.BusExtension;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;

@NoJSR250Annotations
public class BusExtensionPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
Ordered {
    private Bus bus;
    private ApplicationContext context;

    @Override
    public void setApplicationContext(ApplicationContext ctx) {
        this.context = ctx;
    }

    @Override
    public int getOrder() {
        return 1001;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean2, String beanId) throws BeansException {
        return bean2;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanId) throws BeansException {
        if (bean2 instanceof BusExtension && null != this.getBus()) {
            Class<?> cls = ((BusExtension)bean2).getRegistrationType();
            this.registerExt(bean2, cls);
        } else if (bean2 instanceof Bus && "cxf".equals(beanId)) {
            this.bus = (Bus)bean2;
        }
        return bean2;
    }

    private <T> void registerExt(Object bean2, Class<T> cls) {
        this.getBus().setExtension(cls.cast(bean2), cls);
    }

    private Bus getBus() {
        if (this.bus == null) {
            this.bus = (Bus)this.context.getBean("cxf");
        }
        return this.bus;
    }
}

