/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.cxf.endpoint.ClientCallback;

class JaxwsClientCallback<T>
extends ClientCallback {
    final AsyncHandler<T> handler;
    final Object proxy;

    JaxwsClientCallback(AsyncHandler<T> handler, Object p) {
        this.handler = handler;
        this.proxy = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleResponse(Map<String, Object> ctx, Object[] res) {
        this.context = ctx;
        this.result = res;
        if (this.handler != null) {
            this.handler.handleResponse(new Response<T>(){

                public Map<String, Object> getContext() {
                    return JaxwsClientCallback.this.context;
                }

                public boolean cancel(boolean mayInterruptIfRunning) {
                    JaxwsClientCallback.this.cancelled = true;
                    return true;
                }

                public T get() throws InterruptedException, ExecutionException {
                    return JaxwsClientCallback.this.result[0];
                }

                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return JaxwsClientCallback.this.result[0];
                }

                public boolean isCancelled() {
                    return JaxwsClientCallback.this.cancelled;
                }

                public boolean isDone() {
                    return true;
                }
            });
        }
        this.done = true;
        JaxwsClientCallback jaxwsClientCallback = this;
        synchronized (jaxwsClientCallback) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, Object> ctx, final Throwable ex) {
        this.context = ctx;
        this.exception = this.mapThrowable(ex);
        if (this.handler != null) {
            this.handler.handleResponse(new Response<T>(){

                public Map<String, Object> getContext() {
                    return JaxwsClientCallback.this.context;
                }

                public boolean cancel(boolean mayInterruptIfRunning) {
                    JaxwsClientCallback.this.cancelled = true;
                    return true;
                }

                public T get() throws InterruptedException, ExecutionException {
                    throw new ExecutionException(ex);
                }

                public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    throw new ExecutionException(ex);
                }

                public boolean isCancelled() {
                    return JaxwsClientCallback.this.cancelled;
                }

                public boolean isDone() {
                    return true;
                }
            });
        }
        this.done = true;
        JaxwsClientCallback jaxwsClientCallback = this;
        synchronized (jaxwsClientCallback) {
            this.notifyAll();
        }
    }

    protected Throwable mapThrowable(Throwable t) {
        return t;
    }
}

