/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRemovalCallback;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;

public class AttachmentCallbackHandler
implements CallbackHandler {
    private final SoapMessage soapMessage;

    public AttachmentCallbackHandler(SoapMessage soapMessage) {
        this.soapMessage = soapMessage;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        block0: for (Callback callback : callbacks) {
            if (callback instanceof AttachmentRequestCallback) {
                AttachmentRequestCallback attachmentRequestCallback = (AttachmentRequestCallback)callback;
                ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
                attachmentRequestCallback.setAttachments(attachmentList);
                String attachmentId = attachmentRequestCallback.getAttachmentId();
                if ("Attachments".equals(attachmentId)) {
                    attachmentId = null;
                }
                this.loadAttachments(attachmentList, attachmentId, attachmentRequestCallback.isRemoveAttachments());
                continue;
            }
            if (callback instanceof AttachmentResultCallback) {
                AttachmentResultCallback attachmentResultCallback = (AttachmentResultCallback)callback;
                if (this.soapMessage.getAttachments() == null) {
                    this.soapMessage.setAttachments(new ArrayList<org.apache.cxf.message.Attachment>());
                }
                Collection<org.apache.cxf.message.Attachment> attachments = this.soapMessage.getAttachments();
                AttachmentImpl securedAttachment = new AttachmentImpl(attachmentResultCallback.getAttachmentId(), new DataHandler((DataSource)new AttachmentDataSource(attachmentResultCallback.getAttachment().getMimeType(), attachmentResultCallback.getAttachment().getSourceStream())));
                Map<String, String> headers = attachmentResultCallback.getAttachment().getHeaders();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    securedAttachment.setHeader(entry.getKey(), entry.getValue());
                }
                attachments.add(securedAttachment);
                continue;
            }
            if (callback instanceof AttachmentRemovalCallback) {
                Collection<org.apache.cxf.message.Attachment> attachments;
                AttachmentRemovalCallback attachmentRemovalCallback = (AttachmentRemovalCallback)callback;
                String attachmentId = attachmentRemovalCallback.getAttachmentId();
                if (attachmentId == null || (attachments = this.soapMessage.getAttachments()) == null || attachments.size() <= 0) continue;
                Iterator<org.apache.cxf.message.Attachment> iterator = attachments.iterator();
                while (iterator.hasNext()) {
                    org.apache.cxf.message.Attachment attachment = iterator.next();
                    if (!attachmentId.equals(attachment.getId())) continue;
                    iterator.remove();
                    continue block0;
                }
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupported callback");
        }
    }

    private void loadAttachments(List<Attachment> attachmentList, String attachmentId, boolean removeAttachments) throws IOException {
        Collection<org.apache.cxf.message.Attachment> attachments = this.soapMessage.getAttachments();
        if (attachments != null && attachments.size() > 0) {
            Iterator<org.apache.cxf.message.Attachment> iterator = attachments.iterator();
            while (iterator.hasNext()) {
                org.apache.cxf.message.Attachment attachment = iterator.next();
                if (attachmentId != null && !attachmentId.equals(attachment.getId())) continue;
                Attachment att = new Attachment();
                att.setMimeType(attachment.getDataHandler().getContentType());
                att.setId(attachment.getId());
                att.setSourceStream(attachment.getDataHandler().getInputStream());
                Iterator<String> headerIterator = attachment.getHeaderNames();
                while (headerIterator.hasNext()) {
                    String next = headerIterator.next();
                    att.addHeader(next, attachment.getHeader(next));
                }
                attachmentList.add(att);
                if (!removeAttachments) continue;
                iterator.remove();
            }
        }
    }
}

