/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;

public class DynamicJAXBContextFactory {
    public static final String XML_SCHEMA_KEY = "xml-schema";
    public static final String ENTITY_RESOLVER_KEY = "entity-resolver";
    public static final String EXTERNAL_BINDINGS_KEY = "external-bindings";
    public static final String SCHEMAMETADATA_CLASS_NAME = "org.eclipse.persistence.jaxb.dynamic.metadata.SchemaMetadata";

    public static DynamicJAXBContext createContext(String contextPath, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        Object schema = null;
        EntityResolver resolver2 = null;
        Object bindings = null;
        if (properties != null) {
            schema = properties.get(XML_SCHEMA_KEY);
            resolver2 = (EntityResolver)properties.get(ENTITY_RESOLVER_KEY);
            bindings = properties.get("eclipselink.oxm.metadata-source");
            if (bindings == null) {
                bindings = properties.get("eclipselink-oxm-xml");
            }
        }
        if (schema != null) {
            if (schema instanceof Node) {
                return DynamicJAXBContextFactory.createContextFromXSD((Node)schema, resolver2, classLoader, properties);
            }
            if (schema instanceof InputStream) {
                return DynamicJAXBContextFactory.createContextFromXSD((InputStream)schema, resolver2, classLoader, properties);
            }
            if (schema instanceof Source) {
                return DynamicJAXBContextFactory.createContextFromXSD((Source)schema, resolver2, classLoader, properties);
            }
        }
        if (bindings != null) {
            return DynamicJAXBContextFactory.createContextFromOXM(classLoader, properties);
        }
        if (contextPath != null) {
            return new DynamicJAXBContext(new DynamicJAXBContext.SessionsXmlContextInput(contextPath, properties, classLoader));
        }
        throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.nullSessionName());
    }

    public static DynamicJAXBContext createContext(Class<?>[] classes, Map<String, Object> properties) throws JAXBException {
        throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.cannotCreateDynamicContextFromClasses());
    }

    public static DynamicJAXBContext createContextFromXSD(Node schemaDOM, EntityResolver resolver2, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (schemaDOM == null) {
            throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.nullNode());
        }
        if (resolver2 != null) {
            throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.xsdImportNotSource());
        }
        DynamicJAXBContext ctx = new DynamicJAXBContext(new DynamicJAXBContext.SchemaContextInput(schemaDOM, resolver2, properties, classLoader));
        DynamicJAXBContextFactory.fixDateTimeConversion(ctx);
        return ctx;
    }

    public static DynamicJAXBContext createContextFromXSD(InputStream schemaStream, EntityResolver resolver2, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (schemaStream == null) {
            throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.nullInputStream());
        }
        DynamicJAXBContext ctx = new DynamicJAXBContext(new DynamicJAXBContext.SchemaContextInput(schemaStream, resolver2, properties, classLoader));
        DynamicJAXBContextFactory.fixDateTimeConversion(ctx);
        return ctx;
    }

    public static DynamicJAXBContext createContextFromXSD(Source schemaSource, EntityResolver resolver2, ClassLoader classLoader, Map<String, Object> properties) throws JAXBException {
        if (schemaSource == null) {
            throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.nullSource());
        }
        DynamicJAXBContext ctx = new DynamicJAXBContext(new DynamicJAXBContext.SchemaContextInput(schemaSource, resolver2, properties, classLoader));
        DynamicJAXBContextFactory.fixDateTimeConversion(ctx);
        return ctx;
    }

    public static DynamicJAXBContext createContextFromOXM(ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (properties == null || properties.get("eclipselink.oxm.metadata-source") == null && properties.get("eclipselink-oxm-xml") == null) {
            throw new JAXBException(org.eclipse.persistence.exceptions.JAXBException.oxmKeyNotFound());
        }
        return new DynamicJAXBContext(new DynamicJAXBContext.MetadataContextInput(properties, classLoader));
    }

    private static void fixDateTimeConversion(DynamicJAXBContext ctx) {
        XMLConversionManager conversionManager = (XMLConversionManager)((DatabaseSession)ctx.getXMLContext().getSession()).getDatasourcePlatform().getConversionManager();
        HashMap defaultXmlTypes = XMLConversionManager.getDefaultXMLTypes();
        defaultXmlTypes.remove(Constants.DATE_TIME_QNAME);
        defaultXmlTypes.put(Constants.DATE_TIME_QNAME, CoreClassConstants.XML_GREGORIAN_CALENDAR);
        HashMap defaultJavaTypes = XMLConversionManager.getDefaultJavaTypes();
        defaultJavaTypes.remove(CoreClassConstants.CALENDAR);
        defaultJavaTypes.put(CoreClassConstants.XML_GREGORIAN_CALENDAR, Constants.DATE_TIME_QNAME);
    }
}

