/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.MarshalRecordContentHandler;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Node node;

    public NodeRecord() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xmlPlatform.createDocument();
        this.node = this.document;
    }

    public NodeRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public NodeRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        Element rootElement = this.document.createElementNS(rootElementNamespaceURI, rootElementName);
        this.document.appendChild(rootElement);
        this.setDOM(rootElement);
    }

    public NodeRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public NodeRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public NodeRecord(Node node) {
        this.setDOM(node);
        ((NamespaceResolver)this.getNamespaceResolver()).setDOM(node);
    }

    @Override
    public String getLocalName() {
        return this.node.getLocalName();
    }

    @Override
    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    @Override
    public void clear() {
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public Node getDOM() {
        return this.node;
    }

    public void setDOM(Node dom) {
        short nodeType = dom.getNodeType();
        if (9 == nodeType) {
            this.document = (Document)dom;
            this.node = dom;
        } else if (1 == nodeType || 11 == nodeType) {
            this.document = dom.getOwnerDocument();
            this.node = dom;
            ((NamespaceResolver)this.getNamespaceResolver()).setDOM(dom);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    @Override
    public String transformToXML() {
        return null;
    }

    @Override
    public void startDocument(String encoding, String version) {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String uri, String name) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            this.transformChildren(node, this.document, this.node, uri, name);
        }
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            super.openStartElement(xPathFragment, namespaceResolver);
            Element element = this.document.createElementNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment));
            this.node = this.node.appendChild(element);
        }
        catch (DOMException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void element(XPathFragment frag) {
        Element element = this.document.createElementNS(frag.getNamespaceURI(), this.getNameForFragment(frag));
        this.node.appendChild(element);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        if (this.node.getNodeType() == 1) {
            ((Element)this.getDOM()).setAttributeNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment), value);
        }
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value) {
        if (this.node.getNodeType() == 1) {
            ((Element)this.getDOM()).setAttributeNS(namespaceURI, qName, value);
        }
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.node = this.node.getParentNode();
    }

    @Override
    public void characters(String value) {
        if (value.length() > 0) {
            this.node.appendChild(this.document.createTextNode(value));
        }
    }

    @Override
    public void cdata(String value) {
        CDATASection cdata = this.document.createCDATASection(value);
        this.node.appendChild(cdata);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    private void transformChildren(Node sourceNode, Document targetDoc, Node targetNode, String namespace, String name) {
        NodeList children;
        if (targetNode == null) {
            targetNode = targetDoc;
        }
        Element sourceElement = null;
        String xmlRootQualifiedName = name;
        if (sourceNode.getNodeType() == 9) {
            sourceElement = ((Document)sourceNode).getDocumentElement();
        } else if (sourceNode.getNodeType() == 1) {
            sourceElement = (Element)sourceNode;
        }
        NamespaceResolver sourceNR = new NamespaceResolver();
        sourceNR.setDOM(sourceElement);
        NamespaceResolver targetNR = new NamespaceResolver();
        targetNR.setDOM(targetNode);
        String prefix = this.getPrefix(namespace, sourceNR, sourceElement);
        if (prefix != null && prefix.length() > 0) {
            xmlRootQualifiedName = String.valueOf(prefix) + ':' + name;
        }
        if (xmlRootQualifiedName == null && sourceElement != null) {
            namespace = sourceElement.getNamespaceURI();
            xmlRootQualifiedName = sourceElement.getNodeName();
        }
        if (xmlRootQualifiedName != null) {
            Element newElement = null;
            if (namespace == null) {
                newElement = targetDoc.createElement(xmlRootQualifiedName);
                if (targetNR.getDefaultNamespaceURI() != null) {
                    newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                }
            } else {
                newElement = targetDoc.createElementNS(namespace, xmlRootQualifiedName);
                if (prefix == null) {
                    prefix = newElement.getPrefix();
                }
            }
            if (prefix != null && prefix.length() > 0 && targetNR.resolveNamespaceURI(namespace) == null) {
                newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
            }
            targetNode.appendChild(newElement);
            this.copyAttributes(sourceElement.getAttributes(), sourceElement, newElement, sourceNR, targetNR);
            sourceNode = sourceElement;
            targetNode = newElement;
        }
        if ((children = sourceNode.getChildNodes()) != null) {
            int childrenSize = children.getLength();
            int i = 0;
            while (i < childrenSize) {
                Node nextChild = children.item(i);
                Node imported = targetDoc.importNode(nextChild, true);
                targetNode.appendChild(imported);
                ++i;
            }
        }
    }

    private void copyAttributes(NamedNodeMap attrs, Element sourceElement, Element newElement, NamespaceResolver sourceNR, NamespaceResolver targetNR) {
        int i = 0;
        while (i < attrs.getLength()) {
            String prefix;
            Attr nextAttr = (Attr)attrs.item(i);
            String name = nextAttr.getLocalName();
            if (name == null) {
                name = nextAttr.getName();
            }
            String uri = nextAttr.getNamespaceURI();
            if (!"xmlns".equals(name) && (prefix = this.getPrefix(uri, sourceNR, sourceElement)) != null && prefix.length() > 0) {
                name = String.valueOf(prefix) + ':' + name;
                if (targetNR.resolveNamespaceURI(uri) == null) {
                    newElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
            }
            if (uri == null) {
                newElement.setAttribute(name, nextAttr.getValue());
            } else {
                newElement.setAttributeNS(uri, name, nextAttr.getValue());
            }
            ++i;
        }
    }

    private String getPrefix(String namespace, NamespaceResolver sourceNR, Element sourceElement) {
        if (namespace == null) {
            return null;
        }
        String prefix = sourceNR.resolveNamespaceURI(namespace);
        if (prefix == null) {
            String defaultNamespace = sourceElement.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            prefix = defaultNamespace == null ? sourceNR.generatePrefix() : (defaultNamespace != namespace ? ("http://www.w3.org/2001/XMLSchema-instance".equals(namespace) ? sourceNR.generatePrefix("xsi") : sourceNR.generatePrefix()) : "");
        }
        return prefix;
    }

    protected class NodeRecordContentHandler
    extends MarshalRecordContentHandler {
        Map<String, String> prefixMappings;

        public NodeRecordContentHandler(NodeRecord nRec, NamespaceResolver resolver2) {
            super(nRec, resolver2);
            this.prefixMappings = new HashMap<String, String>();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Element element = namespaceURI == null ? NodeRecord.this.document.createElement(qName) : NodeRecord.this.document.createElementNS(namespaceURI, qName);
            NodeRecord.this.node = NodeRecord.this.node.appendChild(element);
            int i = 0;
            while (i < atts.getLength()) {
                this.marshalRecord.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
                ++i;
            }
            if (!this.prefixMappings.isEmpty()) {
                for (Map.Entry<String, String> entry : this.prefixMappings.entrySet()) {
                    String namespaceDeclarationPrefix = entry.getKey();
                    if (namespaceDeclarationPrefix == null || namespaceDeclarationPrefix.length() == 0) {
                        String namespaceDeclarationURI = entry.getValue();
                        if (namespaceDeclarationURI == null) {
                            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                            continue;
                        }
                        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceDeclarationURI);
                        continue;
                    }
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getKey(), entry.getValue());
                }
                this.prefixMappings.clear();
            }
            this.marshalRecord.closeStartElement();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = ((NamespaceResolver)NodeRecord.this.getNamespaceResolver()).resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }
    }
}

