/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.HttpClient;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.AbstractDynamicHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPEntityIDRequestURLBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionDrivenDynamicHTTPMetadataResolver
extends AbstractDynamicHTTPMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(FunctionDrivenDynamicHTTPMetadataResolver.class);
    private Function<String, String> requestURLBuilder;

    public FunctionDrivenDynamicHTTPMetadataResolver(HttpClient client) {
        this(null, client);
    }

    public FunctionDrivenDynamicHTTPMetadataResolver(@Nullable Timer backgroundTaskTimer, @Nonnull HttpClient client) {
        super(backgroundTaskTimer, client);
        this.setRequestURLBuilder(new HTTPEntityIDRequestURLBuilder());
    }

    @Nonnull
    public Function<String, String> getRequestURLBuilder() {
        return this.requestURLBuilder;
    }

    public void setRequestURLBuilder(@Nonnull Function<String, String> builder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.requestURLBuilder = Constraint.isNotNull(builder, "Request URL builder function was null");
    }

    @Override
    @Nullable
    protected String buildRequestURL(@Nonnull CriteriaSet criteria) {
        String entityID = StringSupport.trimOrNull(criteria.get(EntityIdCriterion.class).getEntityId());
        if (entityID == null) {
            return null;
        }
        String url = this.getRequestURLBuilder().apply(entityID);
        this.log.debug("{} URL generated by request builder was: {}", (Object)this.getLogPrefix(), (Object)url);
        return url;
    }
}

