/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import com.google.common.base.Strings;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.core.RespondWith;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class RequestAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(RequestAbstractType.class);

    @Override
    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)super.unmarshall(domElement);
        if (request.getVersion() != SAMLVersion.VERSION_10 && !Strings.isNullOrEmpty(request.getID())) {
            domElement.setIdAttributeNS(null, "RequestID", true);
        }
        return request;
    }

    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        RequestAbstractType request = (RequestAbstractType)parentSAMLObject;
        if (childSAMLObject instanceof Signature) {
            request.setSignature((Signature)childSAMLObject);
        } else if (childSAMLObject instanceof RespondWith) {
            request.getRespondWiths().add((RespondWith)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlElement, Attr attribute) throws UnmarshallingException {
        block15: {
            RequestAbstractType request = (RequestAbstractType)samlElement;
            if ("RequestID".equals(attribute.getLocalName())) {
                request.setID(attribute.getValue());
            } else if ("IssueInstant".equals(attribute.getLocalName()) && !Strings.isNullOrEmpty(attribute.getValue())) {
                DateTime cal = new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC());
                request.setIssueInstant(cal);
            } else {
                if (attribute.getLocalName().equals("MajorVersion")) {
                    try {
                        int major = Integer.parseInt(attribute.getValue());
                        if (major != 1) {
                            throw new UnmarshallingException("MajorVersion was invalid, must be 1");
                        }
                        break block15;
                    }
                    catch (NumberFormatException n) {
                        this.log.error("Failed to parse major version string", n);
                        throw new UnmarshallingException(n);
                    }
                }
                if ("MinorVersion".equals(attribute.getLocalName())) {
                    int minor;
                    try {
                        minor = Integer.parseInt(attribute.getValue());
                    }
                    catch (NumberFormatException n) {
                        this.log.error("Unable to parse minor version string", n);
                        throw new UnmarshallingException(n);
                    }
                    if (minor == 0) {
                        request.setVersion(SAMLVersion.VERSION_10);
                    } else if (minor == 1) {
                        request.setVersion(SAMLVersion.VERSION_11);
                    }
                } else {
                    super.processAttribute(samlElement, attribute);
                }
            }
        }
    }
}

