/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.core.adapter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;

public class DateTimeMillisAdapter
extends XmlAdapter<String, Date> {
    private static final ThreadLocal<DateFormat> THREAD_LOCAL_DATE_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
        }
    };

    @Override
    public String marshal(Date value) throws Exception {
        return value != null ? THREAD_LOCAL_DATE_FORMATTER.get().format(value) : null;
    }

    @Override
    public Date unmarshal(String value) throws Exception {
        return !StringUtils.isEmpty(value) ? THREAD_LOCAL_DATE_FORMATTER.get().parse(value) : null;
    }

    public static void main(String[] args) throws Exception {
        DateTimeMillisAdapter dateTimeMillisAdapter = new DateTimeMillisAdapter();
        Date current = new Date();
        System.out.println(current.getTime());
        System.out.println(dateTimeMillisAdapter.marshal(current));
        long minute = 60000L;
        Date expireDate = new Date(System.currentTimeMillis() + minute);
        System.out.println(expireDate);
    }
}

